/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceSettings;
import org.kie.workbench.common.screens.datasource.management.backend.core.DefaultDriverInitializer;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefChangeHandler;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefResourceChangeObserver;
import org.kie.workbench.common.screens.datasource.management.util.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class DataSourceManagementBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceManagementBootstrap.class);
    public static final String DEPLOYMENTS_INITIALIZATION_RETRIES = "datasource.management.deploymentsInitializationRetries";
    public static final String DEPLOYMENTS_INITIALIZATION_DELAY = "datasource.management.deploymentsInitializationDelay";
    public static final String DEF_CHANGE_HANDLER_BEAN = "datasource.management.DefChangeHandler";
    private DataSourceRuntimeManager dataSourceRuntimeManager;
    private DataSourceDefDeployer dataSourceDefDeployer;
    private DriverDefDeployer driverDefDeployer;
    private DefaultDriverInitializer driverInitializer;
    private DefResourceChangeObserver defResourceChangeObserver;
    private BeanManager beanManager;
    protected long deploymentsInitializationRetries = 20L;
    protected long deploymentsInitializationDelay = 30000L;
    protected ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public DataSourceManagementBootstrap() {
    }

    @Inject
    public DataSourceManagementBootstrap(DataSourceRuntimeManager dataSourceRuntimeManager, DataSourceDefDeployer dataSourceDefDeployer, DriverDefDeployer driverDefDeployer, DefaultDriverInitializer driverInitializer, DefResourceChangeObserver defResourceChangeObserver, BeanManager beanManager) {
        this.dataSourceRuntimeManager = dataSourceRuntimeManager;
        this.dataSourceDefDeployer = dataSourceDefDeployer;
        this.driverDefDeployer = driverDefDeployer;
        this.driverInitializer = driverInitializer;
        this.defResourceChangeObserver = defResourceChangeObserver;
        this.beanManager = beanManager;
    }

    @PostConstruct
    public void init() {
        this.initializeConfigParams();
        this.initializeDefChangeHandler();
        this.driverInitializer.initializeDefaultDrivers();
        this.scheduler.schedule(this.getInitializeDeploymentsTask(), this.deploymentsInitializationDelay, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void destroy() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            try {
                this.scheduler.shutdownNow();
            }
            catch (Exception e) {
                logger.warn("DataSourceManagementBootstrap termination error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void initializeDeployments() {
        this.driverDefDeployer.deployGlobalDefs();
        this.dataSourceDefDeployer.deployGlobalDefs();
    }

    protected void initializeDefChangeHandler() {
        logger.info("Initializing data source definitions change handler");
        String defChangeHandlerName = ServiceUtil.getManagedProperty(DataSourceSettings.getInstance().getProperties(), DEF_CHANGE_HANDLER_BEAN);
        if (defChangeHandlerName != null) {
            try {
                this.defResourceChangeObserver.setDefChangeHandler(this.getDefChangeHandler(defChangeHandlerName));
            }
            catch (Exception e) {
                logger.error("An error was produced during defChangeHandler initialization: " + defChangeHandlerName, (Throwable)e);
            }
        } else {
            logger.info("defChangeHandler was not set");
        }
    }

    protected void initializeConfigParams() {
        String value = null;
        try {
            value = ServiceUtil.getManagedProperty(DataSourceSettings.getInstance().getProperties(), DEPLOYMENTS_INITIALIZATION_RETRIES, Long.toString(this.deploymentsInitializationRetries));
            this.deploymentsInitializationRetries = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Wrong integer value: " + value + " was set for property: " + DEPLOYMENTS_INITIALIZATION_RETRIES + " The by default value: " + this.deploymentsInitializationRetries + " will be used instead.");
        }
        try {
            value = ServiceUtil.getManagedProperty(DataSourceSettings.getInstance().getProperties(), DEPLOYMENTS_INITIALIZATION_DELAY, Long.toString(this.deploymentsInitializationDelay));
            this.deploymentsInitializationDelay = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Wrong integer value: " + value + " was set for property: " + DEPLOYMENTS_INITIALIZATION_DELAY + " The by default value: " + this.deploymentsInitializationDelay + " will be used instead.");
        }
    }

    protected Runnable getInitializeDeploymentsTask() {
        return () -> {
            try {
                logger.debug("Initialize deployments task started.");
                --this.deploymentsInitializationRetries;
                this.dataSourceRuntimeManager.hasStarted();
                this.initializeDeployments();
                logger.info("Initialize deployments task finished successfully.");
                this.scheduler.shutdown();
            }
            catch (Exception e) {
                logger.warn("Initialize deployments task finished with errors: " + e.getMessage());
                if (this.deploymentsInitializationRetries > 0L) {
                    logger.warn("Startup drivers and datasources initialization will be retried again in: " + this.deploymentsInitializationDelay + " " + TimeUnit.MILLISECONDS.name() + "(" + this.deploymentsInitializationRetries + " attempts left)");
                    this.scheduler.schedule(this.getInitializeDeploymentsTask(), this.deploymentsInitializationDelay, TimeUnit.MILLISECONDS);
                }
                logger.error("No more retries are available, some drivers or datasources might not work properly. " + e.getMessage(), (Throwable)e);
                this.scheduler.shutdown();
            }
        };
    }

    protected DefChangeHandler getDefChangeHandler(String defChangeHandlerName) {
        return (DefChangeHandler)ServiceUtil.getManagedBean(this.beanManager, defChangeHandlerName);
    }
}

