/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.command.impl;

import java.util.LinkedList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;

@Portable
public class CompositeCommand<T, V>
extends AbstractCompositeCommand<T, V> {
    private final boolean reverse;

    public CompositeCommand(@MapsTo(value="reverse") boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    protected CommandResult<V> doAllow(T context, Command<T, V> command) {
        return command.allow(context);
    }

    @Override
    protected CommandResult<V> doExecute(T context, Command<T, V> command) {
        return command.execute(context);
    }

    @Override
    protected CommandResult<V> doUndo(T context, Command<T, V> command) {
        return command.undo(context);
    }

    @Override
    public boolean isUndoReverse() {
        return this.reverse;
    }

    @NonPortable
    public static class Builder<T, V> {
        private final LinkedList<Command<T, V>> commands = new LinkedList();
        private boolean reverse = true;

        public Builder<T, V> reverse() {
            this.reverse = true;
            return this;
        }

        public Builder<T, V> forward() {
            this.reverse = false;
            return this;
        }

        public Builder<T, V> addFirstCommand(Command<T, V> command) {
            this.commands.addFirst(command);
            return this;
        }

        public Builder<T, V> addCommand(Command<T, V> command) {
            this.commands.add(command);
            return this;
        }

        public Builder<T, V> addCommands(List<Command<T, V>> _commands) {
            this.commands.addAll(_commands);
            return this;
        }

        public int size() {
            return this.commands.size();
        }

        public Command<T, V> get(int index) {
            return this.commands.get(index);
        }

        public CompositeCommand<T, V> build() {
            CompositeCommand compositeCommand = new CompositeCommand(this.reverse);
            this.commands.forEach(compositeCommand::addCommand);
            return compositeCommand;
        }
    }
}

