/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.domain;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.lookup.domain.DomainLookupContext;
import org.kie.workbench.common.stunner.core.lookup.domain.DomainLookupFunctions;
import org.kie.workbench.common.stunner.core.lookup.domain.DomainLookupsCache;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class CommonDomainLookups {
    private final DefinitionUtils definitionUtils;
    private final DefinitionsCacheRegistry definitionsRegistry;
    private final RuleManager ruleManager;
    private final Function<String, DomainLookupsCache> cacheBuilder;
    private DomainLookupsCache cache;

    @Inject
    public CommonDomainLookups(DefinitionUtils definitionUtils, DefinitionsCacheRegistry definitionsRegistry, RuleManager ruleManager) {
        this(definitionUtils, definitionsRegistry, ruleManager, defSetId -> new DomainLookupsCache(definitionUtils.getDefinitionManager(), definitionsRegistry, (String)defSetId));
    }

    CommonDomainLookups(DefinitionUtils definitionUtils, DefinitionsCacheRegistry definitionsRegistry, RuleManager ruleManager, Function<String, DomainLookupsCache> cacheBuilder) {
        this.definitionUtils = definitionUtils;
        this.definitionsRegistry = definitionsRegistry;
        this.ruleManager = ruleManager;
        this.cacheBuilder = cacheBuilder;
    }

    public CommonDomainLookups setDomain(String defSetId) {
        assert (null == this.cache);
        this.cache = this.cacheBuilder.apply(defSetId);
        return this;
    }

    public Set<String> lookupTargetConnectors(Node<? extends Definition<Object>, ? extends Edge> sourceNode) {
        DomainLookupContext context = this.newContext();
        return new DomainLookupFunctions.LookupTargetConnectors(sourceNode).execute(context);
    }

    private DomainLookupContext newContext() {
        return new DomainLookupContext(this.getDefinitionManager(), this.definitionsRegistry, this.ruleManager, this.cache);
    }

    public Set<String> lookupTargetNodes(Graph<?, ? extends Node> graph, Node<? extends Definition<Object>, ? extends Edge> sourceNode, String edgeId) {
        return this.lookupTargetNodes(graph, sourceNode, edgeId, def -> true);
    }

    public Set<String> lookupTargetNodes(Graph<?, ? extends Node> graph, Node<? extends Definition<Object>, ? extends Edge> sourceNode, String edgeId, Predicate<String> definitionIdsAllowedFilter) {
        DomainLookupContext context = this.newContext();
        Set<String> targetRoles = new DomainLookupFunctions.LookupTargetRoles(sourceNode, edgeId).execute(context);
        Set<String> allowedTargetDefinitions = new DomainLookupFunctions.LookupAllowedDefinitionsByLabels(graph, targetRoles, definitionIdsAllowedFilter).execute(context);
        return new DomainLookupFunctions.FilterConnectionTargetDefinitions(edgeId, allowedTargetDefinitions).execute(context);
    }

    public Set<String> lookupMorphBaseDefinitions(Set<String> definitionIds) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String definitionId : definitionIds) {
            Object definition = this.definitionsRegistry.getDefinitionById(definitionId);
            MorphDefinition morphDefinition = this.definitionUtils.getMorphDefinition(definition);
            boolean hasMorphBase = null != morphDefinition;
            String id = hasMorphBase ? morphDefinition.getDefault() : definitionId;
            result.add(id);
        }
        return result;
    }

    @PreDestroy
    public void destroy() {
        if (null != this.cache) {
            this.cache.clear();
            this.cache = null;
        }
    }

    DomainLookupsCache getCache() {
        return this.cache;
    }

    private DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }
}

