/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.screens;

import elemental2.dom.HTMLElement;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.presenters.ArchetypeTablePresenter;
import org.kie.workbench.common.screens.archetype.mgmt.shared.events.ArchetypeListUpdatedEvent;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.ArchetypeListOperation;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
@WorkbenchScreen(identifier="ArchetypeManagementScreen")
public class ArchetypeManagementScreenPresenter {
    public static final String IDENTIFIER = "ArchetypeManagementScreen";
    private final View view;
    private final TranslationService ts;
    private final Event<NotificationEvent> notificationEvent;
    private final ArchetypeTablePresenter archetypeTablePresenter;
    private final Promises promises;

    @Inject
    public ArchetypeManagementScreenPresenter(View view, TranslationService ts, Event<NotificationEvent> notificationEvent, ArchetypeTablePresenter archetypeTablePresenter, Promises promises) {
        this.view = view;
        this.ts = ts;
        this.notificationEvent = notificationEvent;
        this.archetypeTablePresenter = archetypeTablePresenter;
        this.promises = promises;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.ts.getTranslation("ArchetypeManagement.ArchetypeManagementPerspectiveName");
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @OnOpen
    public void onOpen() {
        this.loadScreen();
    }

    @OnClose
    public void onClose() {
        this.archetypeTablePresenter.reset();
    }

    public void onArchetypeListUpdatedEvent(@Observes ArchetypeListUpdatedEvent event) {
        if (this.archetypeTablePresenter.isSetup()) {
            this.notifyListUpdated(event.getOperation());
        }
    }

    public void notifyListUpdated(ArchetypeListOperation operation) {
        String translationKey;
        switch (operation) {
            case ADD: {
                translationKey = "ArchetypeManagement.ArchetypeAddedMessage";
                break;
            }
            case DELETE: {
                translationKey = "ArchetypeManagement.ArchetypeDeletedMessage";
                break;
            }
            case VALIDATE: {
                translationKey = "ArchetypeManagement.ArchetypeValidatedMessage";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation(translationKey), NotificationEvent.NotificationType.SUCCESS));
    }

    private void loadScreen() {
        this.archetypeTablePresenter.setup(false, () -> {}).then(v -> {
            this.view.setContent(this.archetypeTablePresenter.getView().getElement());
            return this.promises.resolve();
        });
    }

    public static interface View
    extends UberElemental<ArchetypeManagementScreenPresenter> {
        public void setContent(HTMLElement var1);
    }
}

