/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.workitem;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionCacheRegistry;

public class WorkItemDefinitionRegistries<T> {
    private final Function<T, String> keyProvider;
    private final Map<String, WorkItemDefinitionCacheRegistry> registryMap;
    private final Consumer<WorkItemDefinitionCacheRegistry> registryDestroyer;

    public WorkItemDefinitionRegistries(Function<T, String> keyProvider, Map<String, WorkItemDefinitionCacheRegistry> registryMap, Consumer<WorkItemDefinitionCacheRegistry> registryDestroyer) {
        this.keyProvider = keyProvider;
        this.registryMap = registryMap;
        this.registryDestroyer = registryDestroyer;
    }

    public boolean contains(T item) {
        return this.registryMap.containsKey(this.keyProvider.apply(item));
    }

    public Function<T, WorkItemDefinitionCacheRegistry> registries() {
        return this::get;
    }

    public void clear() {
        this.registryMap.values().stream().collect(Collectors.toList()).forEach(this.registryDestroyer);
        this.registryMap.clear();
    }

    public WorkItemDefinitionCacheRegistry put(T item, WorkItemDefinitionCacheRegistry registry) {
        this.registryMap.put(this.keyProvider.apply(item), registry);
        return registry;
    }

    public WorkItemDefinitionCacheRegistry remove(T item) {
        WorkItemDefinitionCacheRegistry removed = this.registryMap.remove(this.keyProvider.apply(item));
        this.registryDestroyer.accept(removed);
        return removed;
    }

    private WorkItemDefinitionCacheRegistry get(T item) {
        return this.registryMap.get(this.keyProvider.apply(item));
    }
}

