/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.PreferenceScopeImpl;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;

@ApplicationScoped
public class PreferenceScopeFactoryImpl
implements PreferenceScopeFactory {
    private PreferenceScopeTypes scopeTypes;

    protected PreferenceScopeFactoryImpl() {
    }

    @Inject
    public PreferenceScopeFactoryImpl(@Customizable PreferenceScopeTypes scopeTypes) {
        this.scopeTypes = scopeTypes;
    }

    @Override
    public PreferenceScope createScope(String type) throws InvalidPreferenceScopeException {
        return this.createScopeWithoutKey(type, null);
    }

    @Override
    public PreferenceScope createScope(String type, PreferenceScope childScope) throws InvalidPreferenceScopeException {
        return this.createScopeWithoutKey(type, childScope);
    }

    @Override
    public PreferenceScope createScope(String type, String key) throws InvalidPreferenceScopeException {
        return this.createScopeWithKey(type, key, null);
    }

    @Override
    public PreferenceScope createScope(String type, String key, PreferenceScope childScope) throws InvalidPreferenceScopeException {
        return this.createScopeWithKey(type, key, childScope);
    }

    @Override
    public PreferenceScope createScope(PreferenceScope ... scopes) throws InvalidPreferenceScopeException {
        PreferenceScope scope = null;
        PreferenceScopeImpl currentScope = null;
        PreferenceScopeImpl previousScope = null;
        for (int i = scopes.length - 1; i >= 0; --i) {
            scope = scopes[i];
            previousScope = currentScope = new PreferenceScopeImpl(scope.type(), scope.key(), previousScope);
        }
        return currentScope;
    }

    @Override
    public PreferenceScope cloneScope(PreferenceScope scope) {
        if (scope == null) {
            return null;
        }
        return new PreferenceScopeImpl(scope.type(), scope.key(), this.cloneScope(scope.childScope()));
    }

    private PreferenceScope createScopeWithoutKey(String type, PreferenceScope childScope) {
        if (this.scopeTypes.typeRequiresKey(type)) {
            throw new InvalidPreferenceScopeException("This preference scope type requires a key to be built.");
        }
        return new PreferenceScopeImpl(type, this.scopeTypes.getDefaultKeyFor(type), childScope);
    }

    private PreferenceScope createScopeWithKey(String type, String key, PreferenceScope childScope) {
        if (!this.scopeTypes.typeRequiresKey(type)) {
            throw new InvalidPreferenceScopeException("This preference scope type does not require a key to be built.");
        }
        return new PreferenceScopeImpl(type, key, childScope);
    }
}

