/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.executor;

import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.model.OpenShiftProvider;
import org.guvnor.ala.openshift.model.OpenShiftProviderImpl;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderBuilder;
import org.guvnor.ala.runtime.providers.ProviderDestroyer;
import org.guvnor.ala.runtime.providers.ProviderId;

public class OpenShiftProviderConfigExecutor
implements ProviderBuilder<OpenShiftProviderConfig, OpenShiftProvider>,
ProviderDestroyer,
FunctionConfigExecutor<OpenShiftProviderConfig, OpenShiftProvider> {
    private RuntimeRegistry runtimeRegistry;

    @Inject
    public OpenShiftProviderConfigExecutor(RuntimeRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public Optional<OpenShiftProvider> apply(OpenShiftProviderConfig openshiftProviderConfig) {
        OpenShiftProvider openshiftProvider;
        if (openshiftProviderConfig.getName() == null || openshiftProviderConfig.getName().isEmpty()) {
            throw new ProvisioningException("No name was provided for the OpenShiftProviderConfig.getName() configuration parameter. You might probably have to properly set the pipeline input parameter: provider-name");
        }
        Provider provider = this.runtimeRegistry.getProvider(openshiftProviderConfig.getName());
        if (provider != null) {
            if (!(provider instanceof OpenShiftProvider)) {
                throw new ProvisioningException("The provider: " + openshiftProviderConfig.getName() + " must be an instance of " + OpenShiftProviderConfig.class + " but is: " + provider.getClass());
            }
            openshiftProvider = (OpenShiftProvider)provider;
        } else {
            openshiftProvider = new OpenShiftProviderImpl(openshiftProviderConfig.getName(), openshiftProviderConfig);
            this.runtimeRegistry.registerProvider((Provider)openshiftProvider);
        }
        return Optional.of(openshiftProvider);
    }

    public Class<? extends Config> executeFor() {
        return OpenShiftProviderConfig.class;
    }

    public String outputId() {
        return "openshift-provider";
    }

    public boolean supports(ProviderConfig config) {
        return config instanceof OpenShiftProviderConfig;
    }

    public boolean supports(ProviderId providerId) {
        return providerId instanceof OpenShiftProvider;
    }

    public void destroy(ProviderId providerId) {
    }
}

