/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.CoreSession;
import com.mysql.cj.conf.HostInfo;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.ResultStreamer;
import com.mysql.cj.protocol.x.ResultCreatingResultListener;
import com.mysql.cj.protocol.x.StatementExecuteOk;
import com.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import com.mysql.cj.protocol.x.XMessageBuilder;
import com.mysql.cj.protocol.x.XProtocol;
import com.mysql.cj.protocol.x.XProtocolError;
import com.mysql.cj.result.RowList;
import com.mysql.cj.xdevapi.FilterParams;
import com.mysql.cj.xdevapi.PreparableStatement;
import com.mysql.cj.xdevapi.SqlDataResult;
import com.mysql.cj.xdevapi.SqlResult;
import com.mysql.cj.xdevapi.SqlResultImpl;
import com.mysql.cj.xdevapi.SqlUpdateResult;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class MysqlxSession
extends CoreSession {
    public MysqlxSession(HostInfo hostInfo, PropertySet propSet) {
        super(null, propSet);
        this.protocol = new XProtocol(hostInfo, propSet);
        this.messageBuilder = this.protocol.getMessageBuilder();
        this.protocol.connect(hostInfo.getUser(), hostInfo.getPassword(), hostInfo.getDatabase());
    }

    public MysqlxSession(XProtocol prot) {
        super(null, prot.getPropertySet());
        this.protocol = prot;
        this.messageBuilder = this.protocol.getMessageBuilder();
    }

    @Override
    public String getProcessHost() {
        return this.protocol.getSocketConnection().getHost();
    }

    public int getPort() {
        return this.protocol.getSocketConnection().getPort();
    }

    @Override
    public void quit() {
        try {
            this.protocol.close();
        }
        catch (IOException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    public Void readOk() {
        ((XProtocol)this.protocol).readOk();
        return null;
    }

    public boolean supportsPreparedStatements() {
        return ((XProtocol)this.protocol).supportsPreparedStatements();
    }

    public boolean readyForPreparingStatements() {
        return ((XProtocol)this.protocol).readyForPreparingStatements();
    }

    public int getNewPreparedStatementId(PreparableStatement<?> preparableStatement) {
        return ((XProtocol)this.protocol).getNewPreparedStatementId(preparableStatement);
    }

    public void freePreparedStatementId(int preparedStatementId) {
        ((XProtocol)this.protocol).freePreparedStatementId(preparedStatementId);
    }

    public boolean failedPreparingStatement(int preparedStatementId, XProtocolError e) {
        return ((XProtocol)this.protocol).failedPreparingStatement(preparedStatementId, e);
    }

    public <T extends ResultStreamer> T find(FilterParams filterParams, Function<ColumnDefinition, BiFunction<RowList, Supplier<StatementExecuteOk>, T>> resultCtor) {
        this.protocol.send(((XMessageBuilder)this.messageBuilder).buildFind(filterParams), 0);
        ColumnDefinition metadata = this.protocol.readMetadata();
        ResultStreamer res = (ResultStreamer)resultCtor.apply(metadata).apply(((XProtocol)this.protocol).getRowInputStream(metadata), this.protocol::readQueryResult);
        this.protocol.setCurrentResultStreamer(res);
        return (T)res;
    }

    public <T extends ResultStreamer> T executePreparedFind(int preparedStatementId, FilterParams filterParams, Function<ColumnDefinition, BiFunction<RowList, Supplier<StatementExecuteOk>, T>> resultCtor) {
        this.protocol.send(((XMessageBuilder)this.messageBuilder).buildPrepareExecute(preparedStatementId, filterParams), 0);
        ColumnDefinition metadata = this.protocol.readMetadata();
        ResultStreamer res = (ResultStreamer)resultCtor.apply(metadata).apply(((XProtocol)this.protocol).getRowInputStream(metadata), this.protocol::readQueryResult);
        this.protocol.setCurrentResultStreamer(res);
        return (T)res;
    }

    public <RES_T> CompletableFuture<RES_T> asyncFind(FilterParams filterParams, Function<ColumnDefinition, BiFunction<RowList, Supplier<StatementExecuteOk>, RES_T>> resultCtor) {
        CompletableFuture f = new CompletableFuture();
        ResultCreatingResultListener<RES_T> l = new ResultCreatingResultListener<RES_T>(resultCtor, f);
        ((XProtocol)this.protocol).asyncFind(filterParams, l, f);
        return f;
    }

    public SqlResult executeSql(String sql, List<Object> args) {
        this.protocol.send((Message)this.messageBuilder.buildSqlStatement(sql, args), 0);
        return this.executeSqlProcessResult();
    }

    private SqlResult executeSqlProcessResult() {
        boolean[] readLastResult = new boolean[1];
        Supplier<StatementExecuteOk> okReader = () -> {
            if (readLastResult[0]) {
                throw new CJCommunicationsException("Invalid state attempting to read ok packet");
            }
            if (((XProtocol)this.protocol).hasMoreResults()) {
                return new StatementExecuteOkBuilder().build();
            }
            readLastResult[0] = true;
            return (StatementExecuteOk)this.protocol.readQueryResult();
        };
        Supplier<SqlResult> resultStream = () -> {
            if (readLastResult[0]) {
                return null;
            }
            if (((XProtocol)this.protocol).isSqlResultPending()) {
                ColumnDefinition metadata = this.protocol.readMetadata();
                return new SqlDataResult(metadata, this.protocol.getServerSession().getDefaultTimeZone(), this.protocol.getRowInputStream(metadata), okReader, this.propertySet);
            }
            readLastResult[0] = true;
            return new SqlUpdateResult((StatementExecuteOk)this.protocol.readQueryResult());
        };
        SqlResultImpl res = new SqlResultImpl(resultStream);
        this.protocol.setCurrentResultStreamer(res);
        return res;
    }

    public CompletableFuture<SqlResult> asyncExecuteSql(String sql, List<Object> args) {
        return ((XProtocol)this.protocol).asyncExecuteSql(sql, args);
    }

    @Override
    public boolean isClosed() {
        return !((XProtocol)this.protocol).isOpen();
    }
}

