/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.conversion;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDataConverterUtil {
    private static final Logger logger = LoggerFactory.getLogger(TaskDataConverterUtil.class);
    private static final Collection<Class> bypassedTypes = Arrays.asList(Object.class, String.class);
    private static final Map<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();

    public static void convert(Map<String, String> typeDefinitions, Map<String, Object> data) {
        typeDefinitions.entrySet().stream().filter(entry -> !TaskDataConverterUtil.isBypassType((String)entry.getValue()) && TaskDataConverterUtil.mightBeConstant(data.get(entry.getKey()))).forEach(entry -> TaskDataConverterUtil.process((String)entry.getKey(), (String)entry.getValue(), data.get(entry.getKey()), newValue -> data.put((String)entry.getKey(), newValue)));
    }

    private static void process(String variable, String type, Object value, Consumer<Object> consumer) {
        Optional<Function> optional = converters.entrySet().stream().filter(entry -> TaskDataConverterUtil.matches((Class)entry.getKey(), type)).map(Map.Entry::getValue).findAny();
        if (optional.isPresent()) {
            Function function = optional.get();
            try {
                consumer.accept(function.apply(value.toString()));
            }
            catch (Exception ex) {
                logger.warn("Couldn't parse constant value '{}' for variable '{}': {}", new Object[]{value, variable, ex});
                logger.warn("Setting variable '{}' to null.", (Object)variable);
                consumer.accept(null);
            }
        } else {
            logger.warn("Variable '{}' has a constant value '{}' that doesn't match the variable type ('{}'). This might cause problems during the form lifecycle.", new Object[]{variable, value, type});
            logger.warn("Setting variable '{}' to null.", (Object)variable);
            consumer.accept(null);
        }
    }

    private static boolean isBypassType(String type) {
        return bypassedTypes.stream().anyMatch(clazz -> TaskDataConverterUtil.matches(clazz, type));
    }

    private static boolean matches(Class clazz, String type) {
        return clazz.getName().equals(type) || clazz.getSimpleName().equals(type);
    }

    private static boolean mightBeConstant(Object value) {
        return value instanceof String;
    }

    static {
        converters.put(Double.class, Double::parseDouble);
        converters.put(Float.class, Float::parseFloat);
        converters.put(Integer.class, Integer::parseInt);
        converters.put(Boolean.class, Boolean::parseBoolean);
    }
}

