/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.validation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.ModelBeanViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;

@Portable
public final class ElementViolationImpl
implements DiagramElementViolation<RuleViolation> {
    private final String uuid;
    private final Collection<RuleViolation> graphViolations;
    private final Collection<ModelBeanViolation> modelViolations;
    private final Collection<DomainViolation> domainViolations;
    private final Violation.Type type;

    ElementViolationImpl(@MapsTo(value="uuid") String uuid, @MapsTo(value="graphViolations") Collection<RuleViolation> graphViolations, @MapsTo(value="modelViolations") Collection<ModelBeanViolation> modelViolations, @MapsTo(value="domainViolations") Collection<DomainViolation> domainViolations, @MapsTo(value="type") Violation.Type type) {
        this.uuid = uuid;
        this.graphViolations = graphViolations;
        this.modelViolations = modelViolations;
        this.domainViolations = domainViolations;
        this.type = type;
    }

    public String getUUID() {
        return this.uuid;
    }

    public Collection<RuleViolation> getGraphViolations() {
        return this.graphViolations;
    }

    public Collection<ModelBeanViolation> getModelViolations() {
        return this.modelViolations;
    }

    public Collection<DomainViolation> getDomainViolations() {
        return this.domainViolations;
    }

    public String getMessage() {
        throw new IllegalStateException("The message should be handled by the caller");
    }

    public Violation.Type getViolationType() {
        return this.type;
    }

    @NonPortable
    public static class Builder {
        private String uuid;
        private Collection<RuleViolation> graphViolations = Collections.emptyList();
        private Collection<ModelBeanViolation> modelViolations = Collections.emptyList();
        private Collection<DomainViolation> domainViolations = Collections.emptyList();
        private Violation.Type type;

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setGraphViolations(Collection<RuleViolation> graphViolations) {
            this.graphViolations = graphViolations;
            return this;
        }

        public Builder setModelViolations(Collection<ModelBeanViolation> modelViolations) {
            this.modelViolations = modelViolations;
            return this;
        }

        public Builder setDomainViolations(Collection<DomainViolation> domainViolations) {
            this.domainViolations = domainViolations;
            return this;
        }

        public Builder setType(Violation.Type type) {
            this.type = type;
            return this;
        }

        public ElementViolationImpl build() {
            if (Objects.isNull(this.type)) {
                this.setType(ValidationUtils.getMaxSeverity((Collection<? extends Violation>)new LinkedHashSet<Violation>(){
                    {
                        Optional.ofNullable(graphViolations).ifPresent(v -> this.addAll(v));
                        Optional.ofNullable(modelViolations).ifPresent(v -> this.addAll(v));
                        Optional.ofNullable(domainViolations).ifPresent(v -> this.addAll(v));
                    }
                }));
            }
            return new ElementViolationImpl(this.uuid, this.graphViolations, this.modelViolations, this.domainViolations, this.type);
        }
    }
}

