/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.artifacts;

import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.TextAnnotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.artifacts.ArtifactsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DataObjectPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArtifactsConverterTest {
    private ArtifactsConverter tested;
    @Mock
    private TypedFactoryManager typedFactoryManager;
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    @Mock
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation>, Edge> nodeTextAnnotation;
    @Mock
    private Node<View<DataObject>, Edge> nodeDataObject;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation> contentTextAnnotation;
    @Mock
    private View<DataObject> contentDataObject;
    @Mock
    private org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation defTextAnnotation;
    @Mock
    private DataObject defDataObject;
    @Mock
    private TextAnnotationPropertyReader readerTextAnnotation;
    @Mock
    private DataObjectPropertyReader readerDataObject;

    @Before
    public void setUp() {
        this.tested = new ArtifactsConverter(this.typedFactoryManager, this.propertyReaderFactory);
    }

    @Test
    public void convertTextAnnotation() {
        TextAnnotation element = Bpmn2Factory.eINSTANCE.createTextAnnotation();
        Mockito.when((Object)this.typedFactoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation.class))).thenReturn(this.nodeTextAnnotation);
        Mockito.when((Object)this.nodeTextAnnotation.getContent()).thenReturn(this.contentTextAnnotation);
        Mockito.when((Object)this.contentTextAnnotation.getDefinition()).thenReturn((Object)this.defTextAnnotation);
        Mockito.when((Object)this.propertyReaderFactory.of(element)).thenReturn((Object)this.readerTextAnnotation);
        Result node = this.tested.convert((FlowElement)element);
        Node value = ((BpmnNode)node.value()).value();
        Assert.assertEquals(this.contentTextAnnotation, (Object)value.getContent());
        Assert.assertEquals((Object)this.defTextAnnotation, (Object)((View)value.getContent()).getDefinition());
    }

    @Test
    public void convertDataObject() {
        DataObjectReference element = Bpmn2Factory.eINSTANCE.createDataObjectReference();
        Mockito.when((Object)this.typedFactoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(DataObject.class))).thenReturn(this.nodeDataObject);
        Mockito.when((Object)this.nodeDataObject.getContent()).thenReturn(this.contentDataObject);
        Mockito.when((Object)this.contentDataObject.getDefinition()).thenReturn((Object)this.defDataObject);
        Mockito.when((Object)this.propertyReaderFactory.of(element)).thenReturn((Object)this.readerDataObject);
        Result node = this.tested.convert((FlowElement)element);
        Node value = ((BpmnNode)node.value()).value();
        Assert.assertEquals(this.contentDataObject, (Object)value.getContent());
        Assert.assertEquals((Object)this.defDataObject, (Object)((View)value.getContent()).getDefinition());
    }
}

