/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BoundaryCatchingIntermediateEventTest<T extends BaseCatchingIntermediateEvent>
extends CatchingIntermediateEventTest<T> {
    private static final int DEFAULT_AMOUNT_OF_INCOME_EDGES = 2;

    BoundaryCatchingIntermediateEventTest() throws Exception {
    }

    @Test
    public void testDockerInfo() throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnCatchingIntermediateEventFilePath());
        String resultXml = this.marshaller.marshall(initialDiagram);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        final HashMap dockerInfos = new HashMap();
        xr.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String s, String s1, String s2, Attributes attributes) {
                if (s1.equals("boundaryEvent")) {
                    dockerInfos.put(attributes.getValue("id"), attributes.getValue("drools:dockerinfo"));
                }
            }
        });
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceAsStream = contextClassLoader.getResourceAsStream(this.getBpmnCatchingIntermediateEventFilePath());
        xr.parse(new InputSource(new InputStreamReader(resourceAsStream)));
        xr.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String s, String s1, String s2, Attributes attributes) {
                if (s1.equals("boundaryEvent")) {
                    String id = attributes.getValue("id");
                    ((AbstractStringAssert)Assertions.assertThat((String)attributes.getValue("drools:dockerinfo")).as("Attributes should match for %s", new Object[]{id})).isEqualTo((String)dockerInfos.remove(id));
                }
            }
        });
        xr.parse(new InputSource(new StringReader(resultXml)));
        ((MapAssert)Assertions.assertThat(dockerInfos).as("the collection should be empty at the end (100% match)", new Object[0])).isEmpty();
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithEdgesFilledProperties() {
        for (String eventId : this.getFilledTopLevelEventWithEdgesIds()) {
            this.checkEventMarshalling(eventId, false, 2);
        }
    }

    @Override
    @Test
    public void testMarshallTopLevelEventWithEdgesEmptyProperties() {
        this.checkEventMarshalling(this.getEmptyTopLevelEventWithEdgesId(), false, 2);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithEdgesFilledProperties() {
        for (String eventId : this.getFilledSubprocessLevelEventWithEdgesIds()) {
            this.checkEventMarshalling(eventId, false, 2);
        }
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventWithEdgesId(), false, 2);
    }

    @Override
    protected int getDefaultAmountOfIncomeEdges() {
        return 2;
    }
}

