/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.service;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.kie.workbench.common.services.backend.builder.ala.BuildPipelineInvoker;
import org.kie.workbench.common.services.backend.builder.ala.LocalBinaryConfig;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.core.DeploymentVerifier;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class BuildServiceHelper {
    private BuildPipelineInvoker buildPipelineInvoker;
    private DeploymentVerifier deploymentVerifier;

    public BuildServiceHelper() {
    }

    @Inject
    public BuildServiceHelper(BuildPipelineInvoker buildPipelineInvoker, DeploymentVerifier deploymentVerifier) {
        this.buildPipelineInvoker = buildPipelineInvoker;
        this.deploymentVerifier = deploymentVerifier;
    }

    public BuildResults localBuild(Module module) {
        BuildResults[] result = new BuildResults[1];
        this.invokeLocalBuildPipeLine(module, localBinaryConfig -> {
            result[0] = localBinaryConfig.getBuildResults();
            result[0].setRootPathURI(module.getRootPath().toURI());
        });
        return result[0];
    }

    public void localBuild(Module module, Consumer<LocalBinaryConfig> consumer) {
        this.invokeLocalBuildPipeLine(module, consumer);
    }

    public IncrementalBuildResults localBuild(Module module, LocalBuildConfig.BuildType buildType, Path resource) {
        IncrementalBuildResults[] result = new IncrementalBuildResults[1];
        this.invokeLocalBuildPipeLine(module, buildType, resource, (LocalBinaryConfig localBinaryConfig) -> {
            result[0] = localBinaryConfig.getIncrementalBuildResults();
            result[0].setRootPathURI(module.getRootPath().toURI());
        });
        return result[0];
    }

    public IncrementalBuildResults localBuild(Module module, Map<Path, Collection<ResourceChange>> resourceChanges) {
        IncrementalBuildResults[] result = new IncrementalBuildResults[1];
        this.invokeLocalBuildPipeLine(module, resourceChanges, localBinaryConfig -> {
            result[0] = localBinaryConfig.getIncrementalBuildResults();
            result[0].setRootPathURI(module.getRootPath().toURI());
        });
        return result[0];
    }

    public BuildResults localBuildAndDeploy(Module module, DeploymentMode mode, boolean suppressHandlers) {
        BuildResults[] result = new BuildResults[1];
        this.invokeLocalBuildPipeLine(module, suppressHandlers, mode, (LocalBinaryConfig localBinaryConfig) -> {
            result[0] = localBinaryConfig.getBuildResults();
            result[0].setRootPathURI(module.getRootPath().toURI());
        });
        return result[0];
    }

    private void invokeLocalBuildPipeLine(Module module, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newFullBuildRequest(module);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Module module, LocalBuildConfig.BuildType buildType, Path resource, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newIncrementalBuildRequest(module, buildType, resource);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Module module, Map<Path, Collection<ResourceChange>> resourceChanges, Consumer<LocalBinaryConfig> consumer) {
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newIncrementalBuildRequest(module, resourceChanges);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private void invokeLocalBuildPipeLine(Module module, boolean suppressHandlers, DeploymentMode mode, Consumer<LocalBinaryConfig> consumer) {
        this.deploymentVerifier.verifyWithException(module, mode);
        BuildPipelineInvoker.LocalBuildRequest buildRequest = BuildPipelineInvoker.LocalBuildRequest.newFullBuildAndDeployRequest(module, this.toDeploymentType(mode), suppressHandlers);
        this.buildPipelineInvoker.invokeLocalBuildPipeLine(buildRequest, consumer);
    }

    private LocalBuildConfig.DeploymentType toDeploymentType(DeploymentMode deploymentMode) {
        return deploymentMode == DeploymentMode.VALIDATED ? LocalBuildConfig.DeploymentType.VALIDATED : LocalBuildConfig.DeploymentType.FORCED;
    }
}

