/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.navigation.NavItemContext;

public class NavItemContextImpl
implements NavItemContext {
    Map<String, String> ctxMap = new HashMap<String, String>();

    public NavItemContextImpl() {
    }

    public NavItemContextImpl(String ctx) {
        this.init(ctx);
    }

    @Override
    public void init(String ctx) {
        this.ctxMap.clear();
        if (ctx != null && ctx.length() > 0) {
            String[] tokens = ctx.split(";");
            for (int i = 0; i < tokens.length; ++i) {
                String[] pair = tokens[i].split("=");
                if (pair.length != 2) continue;
                this.ctxMap.put(pair[0], pair[1]);
            }
        }
    }

    @Override
    public Collection<String> getPropertyIds() {
        return this.ctxMap.keySet();
    }

    @Override
    public String getProperty(String id) {
        return this.ctxMap.get(id);
    }

    @Override
    public String removeProperty(String id) {
        return this.ctxMap.remove(id);
    }

    @Override
    public NavItemContext setProperty(String id, String value) {
        this.ctxMap.put(id, value);
        return this;
    }

    @Override
    public boolean includesPropertiesOf(NavItemContext ctx) {
        for (String p : ctx.getPropertyIds()) {
            String v1 = this.getProperty(p);
            String v2 = ctx.getProperty(p);
            if (v1 == null && v2 != null) {
                return false;
            }
            if (v1 == null || v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        this.ctxMap.keySet().forEach(k -> out.append((String)k).append("=").append(this.ctxMap.get(k)).append(";"));
        return out.toString();
    }
}

