/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerHealthCheckControllerImpl;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.RuleCapabilitiesServiceImpl;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.server.controller.rest.RestRuntimeManagementServiceImpl;
import org.kie.server.controller.rest.RestSpecManagementServiceImpl;
import org.kie.workbench.common.screens.server.management.backend.utils.EmbeddedController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.concurrent.Managed;

@ApplicationScoped
@EmbeddedController
public class KieServerEmbeddedControllerProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerEmbeddedControllerProducer.class);

    @Produces
    @ApplicationScoped
    @EmbeddedController
    public RuleCapabilitiesService produceRuleService(@EmbeddedController KieServerInstanceManager instanceManager, @EmbeddedController NotificationService notificationService, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating RuleCapabilitiesServiceImpl...");
        RuleCapabilitiesServiceImpl service = new RuleCapabilitiesServiceImpl();
        service.setNotificationService(notificationService);
        service.setTemplateStorage(kieServerTemplateStorage);
        service.setKieServerInstanceManager(instanceManager);
        return service;
    }

    @Produces
    @ApplicationScoped
    public SpecManagementServiceImpl produceSpecManagementService(@EmbeddedController KieServerInstanceManager instanceManager, @EmbeddedController NotificationService notificationService, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating SpecManagementServiceImpl...");
        SpecManagementServiceImpl service = new SpecManagementServiceImpl();
        service.setNotificationService(notificationService);
        service.setTemplateStorage(kieServerTemplateStorage);
        service.setKieServerInstanceManager(instanceManager);
        return service;
    }

    @Produces
    @ApplicationScoped
    public RestSpecManagementServiceImpl produceRestSpecManagementService(@EmbeddedController NotificationService notificationService, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating RestSpecManagementServiceImpl...");
        SpecManagementServiceImpl service = new SpecManagementServiceImpl();
        service.setNotificationService(notificationService);
        service.setTemplateStorage(kieServerTemplateStorage);
        service.setKieServerInstanceManager(KieServerInstanceManager.getInstance());
        RestSpecManagementServiceImpl restSpecManagementService = new RestSpecManagementServiceImpl();
        restSpecManagementService.setSpecManagementService(service);
        return restSpecManagementService;
    }

    @Produces
    @ApplicationScoped
    public RuntimeManagementServiceImpl produceRuntimeManagementService(@EmbeddedController KieServerInstanceManager instanceManager, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating RuntimeManagementServiceImpl...");
        RuntimeManagementServiceImpl service = new RuntimeManagementServiceImpl();
        service.setTemplateStorage(kieServerTemplateStorage);
        service.setKieServerInstanceManager(instanceManager);
        return service;
    }

    @Produces
    @ApplicationScoped
    public RestRuntimeManagementServiceImpl produceRestRuntimeManagementService(@EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating RestRuntimeManagementServiceImpl...");
        RuntimeManagementServiceImpl service = new RuntimeManagementServiceImpl();
        service.setTemplateStorage(kieServerTemplateStorage);
        service.setKieServerInstanceManager(KieServerInstanceManager.getInstance());
        RestRuntimeManagementServiceImpl restRuntimeManagementService = new RestRuntimeManagementServiceImpl();
        restRuntimeManagementService.setRuntimeManagementService(service);
        return restRuntimeManagementService;
    }

    @Produces
    @ApplicationScoped
    public RestKieServerControllerImpl produceRestKieServerController(@EmbeddedController NotificationService notificationService, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage) {
        LOGGER.debug("Creating RestKieServerControllerImpl...");
        RestKieServerControllerImpl controller = new RestKieServerControllerImpl();
        controller.setNotificationService(notificationService);
        controller.setTemplateStorage(kieServerTemplateStorage);
        return controller;
    }

    @Produces
    @EmbeddedController
    public KieServerHealthCheckControllerImpl produceKieServerHealthCheckController(@EmbeddedController NotificationService notificationService, @EmbeddedController KieServerTemplateStorage kieServerTemplateStorage, @Managed ExecutorService executorService) {
        LOGGER.debug("Creating KieServerHealthCheckController...");
        KieServerHealthCheckControllerImpl controller = new KieServerHealthCheckControllerImpl();
        controller.setNotificationService(notificationService);
        controller.setTemplateStorage(kieServerTemplateStorage);
        controller.setExecutorService(executorService);
        return controller;
    }
}

