/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.lanes;

import java.util.Optional;
import org.eclipse.bpmn2.Lane;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.LanePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.Violation;

public class LaneConverter
implements NodeConverter<Lane> {
    private final TypedFactoryManager typedFactoryManager;
    private PropertyReaderFactory propertyReaderFactory;

    public LaneConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.typedFactoryManager = typedFactoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(Lane lane) {
        return this.convert(lane, this.propertyReaderFactory.of(lane));
    }

    public Result<BpmnNode> convert(Lane lane, Lane parent) {
        Result<BpmnNode> result = this.convert(lane, this.propertyReaderFactory.of(lane, parent));
        return Optional.ofNullable(result.value()).map(value -> Result.success(value, MarshallingMessage.builder().message(String.format("Child Lane Set %s Converted to Lane %s", parent.getName(), lane.getName())).messageKey("MarshallingMessage.childLaneSetConverted").messageArguments(new String[]{lane.getName(), parent.getName()}).type(Violation.Type.WARNING).build())).get();
    }

    private Result<BpmnNode> convert(Lane lane, LanePropertyReader p) {
        Node node = this.typedFactoryManager.newNode(lane.getId(), org.kie.workbench.common.stunner.bpmn.definition.Lane.class);
        org.kie.workbench.common.stunner.bpmn.definition.Lane definition = (org.kie.workbench.common.stunner.bpmn.definition.Lane)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }
}

