/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.MultipleInstanceActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.NotificationsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ReassignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Actors;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;

public class UserTaskPropertyReader
extends MultipleInstanceActivityPropertyReader {
    private final UserTask task;

    public UserTaskPropertyReader(UserTask element, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((Activity)element, diagram, definitionResolver);
        this.task = element;
    }

    public Actors getActors() {
        List roles = this.task.getResources();
        ArrayList<String> users = new ArrayList<String>();
        for (ResourceRole role : roles) {
            if (!(role instanceof PotentialOwner)) continue;
            FormalExpression fe = (FormalExpression)role.getResourceAssignmentExpression().getExpression();
            users.add(fe.getBody());
        }
        return new Actors(this.renderActors(users));
    }

    private String renderActors(Collection<String> actors) {
        return actors.stream().collect(Collectors.joining(","));
    }

    public ReassignmentsInfo getReassignments() {
        return ReassignmentsInfos.of(this.task.getDataInputAssociations());
    }

    public NotificationsInfo getNotifications() {
        return NotificationsInfos.of(this.task.getDataInputAssociations());
    }

    public String getTaskName() {
        return CustomInput.taskName.of((Task)this.task).get();
    }

    public String getGroupid() {
        return CustomInput.groupId.of((Task)this.task).get();
    }

    public boolean isAsync() {
        return (Boolean)CustomElement.async.of(this.element).get();
    }

    public boolean isSkippable() {
        return CustomInput.skippable.of((Task)this.task).get();
    }

    public String getPriority() {
        return CustomInput.priority.of((Task)this.task).get();
    }

    public String getSubject() {
        return CustomInput.subject.of((Task)this.task).get();
    }

    @Override
    public String getDescription() {
        return CustomInput.description.of((Task)this.task).get();
    }

    public String getCreatedBy() {
        return CustomInput.createdBy.of((Task)this.task).get();
    }

    public boolean isAdHocAutostart() {
        return (Boolean)CustomElement.autoStart.of(this.element).get();
    }

    public String getContent() {
        return CustomInput.content.of((Task)this.task).get();
    }

    public String getSLADueDate() {
        return (String)CustomElement.slaDueDate.of(this.element).get();
    }
}

