/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.backend.maven;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenRequest;
import org.guvnor.common.services.project.model.GAV;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.archetype.mgmt.backend.maven.AbstractMavenCommand;

public class ArchetypeGenerateCommand
extends AbstractMavenCommand {
    public static final List<String> GOALS = Collections.singletonList("archetype:generate");
    public static final String ARCHETYPE_GROUP_ID = "archetypeGroupId";
    public static final String ARCHETYPE_ARTIFACT_ID = "archetypeArtifactId";
    public static final String ARCHETYPE_VERSION = "archetypeVersion";
    public static final String TEMPLATE_GROUP_ID = "groupId";
    public static final String TEMPLATE_ARTIFACT_ID = "artifactId";
    public static final String TEMPLATE_VERSION = "version";
    public static final String ARCHETYPE_CATALOG = "archetypeCatalog";
    public static final String INTERNAL_CATALOG = "internal";
    private final GAV archetypeGAV;
    private final GAV templateGAV;

    public ArchetypeGenerateCommand(String baseDirectory, GAV archetypeGAV, GAV templateGAV) {
        super(baseDirectory);
        this.archetypeGAV = (GAV)PortablePreconditions.checkNotNull((String)"archetypeGAV", (Object)archetypeGAV);
        this.templateGAV = (GAV)PortablePreconditions.checkNotNull((String)"templateGAV", (Object)templateGAV);
    }

    @Override
    public MavenRequest buildMavenRequest() {
        MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest((boolean)false);
        mavenRequest.setGoals(GOALS);
        mavenRequest.setInteractive(false);
        return mavenRequest;
    }

    @Override
    public Properties buildUserProperties() {
        Properties properties = new Properties();
        properties.setProperty(ARCHETYPE_GROUP_ID, this.archetypeGAV.getGroupId());
        properties.setProperty(ARCHETYPE_ARTIFACT_ID, this.archetypeGAV.getArtifactId());
        properties.setProperty(ARCHETYPE_VERSION, this.archetypeGAV.getVersion());
        properties.setProperty(TEMPLATE_GROUP_ID, this.templateGAV.getGroupId());
        properties.setProperty(TEMPLATE_ARTIFACT_ID, this.templateGAV.getArtifactId());
        properties.setProperty(TEMPLATE_VERSION, this.templateGAV.getVersion());
        properties.setProperty(ARCHETYPE_CATALOG, INTERNAL_CATALOG);
        return properties;
    }
}

