/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.api;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.exceptions.BusinessException;

@Path(value="pipelines")
public interface PipelineService {
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PipelineConfigsList getPipelineConfigs(@QueryParam(value="page") @DefaultValue(value="0") Integer var1, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var2, @QueryParam(value="sort") String var3, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var4) throws BusinessException;

    @GET
    @Path(value="providertype")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PipelineConfigsList getPipelineConfigs(@QueryParam(value="providerTypeName") String var1, @QueryParam(value="providerTypeVersion") String var2, @QueryParam(value="page") @DefaultValue(value="0") Integer var3, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var4, @QueryParam(value="sort") String var5, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var6) throws BusinessException;

    @GET
    @Path(value="providertype/names")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<String> getPipelineNames(@QueryParam(value="providerTypeName") String var1, @QueryParam(value="providerTypeVersion") String var2, @QueryParam(value="page") @DefaultValue(value="0") Integer var3, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer var4, @QueryParam(value="sort") String var5, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean var6) throws BusinessException;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String newPipeline(@NotNull PipelineConfig var1) throws BusinessException;

    @POST
    @Path(value="providertype")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String newPipeline(@NotNull PipelineConfig var1, @NotNull ProviderType var2) throws BusinessException;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="execution/{pipelineId}/run")
    public String runPipeline(@PathParam(value="pipelineId") String var1, @NotNull Input var2, @NotNull boolean var3) throws BusinessException;

    @PUT
    @Path(value="execution/{executionId}/stop")
    public void stopPipelineExecution(@PathParam(value="executionId") String var1) throws BusinessException;

    @DELETE
    @Path(value="execution/{executionId}")
    public void deletePipelineExecution(@PathParam(value="executionId") String var1) throws BusinessException;
}

