/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;

public class LayerCrossingCount {
    private static final int DEFAULT_VERTEX_WEIGHT = 1;

    public int crossing(List<OrientedEdge> edges, GraphLayer north, GraphLayer south) {
        int firstIndex;
        Object[] entries = this.flat(edges, north, south);
        for (firstIndex = 1; firstIndex < south.getVertices().size(); firstIndex <<= 1) {
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossings = 0;
        for (Object entry : entries) {
            int index = (Integer)entry + firstIndex;
            if (index < 0) continue;
            int n = index;
            tree[n] = tree[n] + 1;
            int weightSum = 0;
            while (index > 0) {
                if (index % 2 != 0) {
                    weightSum += tree[index + 1];
                }
                int n2 = index = index - 1 >> 1;
                tree[n2] = tree[n2] + 1;
            }
            crossings += 1 * weightSum;
        }
        return crossings;
    }

    int crossing(List<GraphLayer> layers, List<OrientedEdge> edges) {
        int crossingCount = 0;
        for (int i = 1; i < layers.size(); ++i) {
            crossingCount += this.crossing(edges, layers.get(i - 1), layers.get(i));
        }
        return crossingCount;
    }

    private Object[] flat(List<OrientedEdge> edges, GraphLayer north, GraphLayer south) {
        ArrayList<String> southPos = new ArrayList<String>(south.getVertices().size());
        for (int i = 0; i < south.getVertices().size(); ++i) {
            southPos.add(((Vertex)south.getVertices().get(i)).getId());
        }
        return north.getVertices().stream().flatMap(v -> {
            List connectedEdges = edges.stream().filter(e -> e.getToVertexId().equals(v.getId()) || e.getFromVertexId().equals(v.getId())).collect(Collectors.toList());
            return connectedEdges.stream().map(e -> {
                if (southPos.contains(e.getToVertexId())) {
                    return southPos.indexOf(e.getToVertexId());
                }
                return southPos.indexOf(e.getFromVertexId());
            }).sorted();
        }).toArray();
    }
}

