/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNUtils;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNScenarioValidation
extends AbstractScenarioValidation {
    public static final DMNScenarioValidation INSTANCE = new DMNScenarioValidation();

    @Override
    public List<FactMappingValidationError> validate(Simulation simulation, Settings settings, KieContainer kieContainer) {
        ArrayList<FactMappingValidationError> errors = new ArrayList<FactMappingValidationError>();
        String dmnFilePath = settings.getDmnFilePath();
        DMNModel dmnModel = this.getDMNModel(kieContainer, dmnFilePath);
        for (FactMapping factMapping : simulation.getScesimModelDescriptor().getFactMappings()) {
            DMNType factDMNType;
            if (DMNScenarioValidation.isToSkip(factMapping)) continue;
            String nodeName = factMapping.getFactIdentifier().getName();
            try {
                factDMNType = dmnModel.getDecisionByName(nodeName) != null ? dmnModel.getDecisionByName(nodeName).getResultType() : dmnModel.getInputByName(nodeName).getType();
            }
            catch (NullPointerException e) {
                errors.add(FactMappingValidationError.createNodeChangedError((FactMapping)factMapping, (String)"node not found"));
                continue;
            }
            List<String> steps = this.expressionElementToString(factMapping);
            try {
                DMNType fieldType = DMNUtils.navigateDMNType(factDMNType, steps);
                if (this.isDMNFactMappingValid(factMapping, fieldType)) continue;
                errors.add(this.defineFieldChangedError(factMapping, factDMNType, fieldType));
            }
            catch (IllegalStateException e) {
                errors.add(FactMappingValidationError.createGenericError((FactMapping)factMapping, (String)e.getMessage()));
            }
        }
        return errors;
    }

    private FactMappingValidationError defineFieldChangedError(FactMapping factMapping, DMNType factType, DMNType fieldType) {
        String typeName = factMapping.getClassName();
        if (this.isConstraintAdded(typeName, fieldType)) {
            return FactMappingValidationError.createFieldAddedConstraintError((FactMapping)factMapping);
        }
        if (this.isConstraintRemoved(typeName, factType, fieldType)) {
            return FactMappingValidationError.createFieldRemovedConstraintError((FactMapping)factMapping);
        }
        return FactMappingValidationError.createFieldChangedError((FactMapping)factMapping, (String)fieldType.getName());
    }

    private boolean isDMNFactMappingValid(FactMapping factMapping, DMNType dmnType) {
        boolean isCoherent;
        Type rootType = DMNUtils.getRootType((BaseDMNTypeImpl)dmnType);
        String typeName = factMapping.getClassName();
        boolean bl = isCoherent = BuiltInType.UNKNOWN.equals((Object)rootType) || ScenarioSimulationSharedUtils.isList((String)typeName) == dmnType.isCollection();
        if (!isCoherent) {
            return false;
        }
        String factMappingType = ScenarioSimulationSharedUtils.isList((String)typeName) ? (String)factMapping.getGenericTypes().get(0) : typeName;
        return Objects.equals(factMappingType, dmnType.getName());
    }

    private boolean isConstraintAdded(String typeName, DMNType fieldType) {
        boolean isTypeNameBuiltInType = !Objects.equals(BuiltInType.UNKNOWN, BuiltInType.determineTypeFromName((String)typeName));
        boolean hasFieldTypeAllowedValues = fieldType.getAllowedValues() != null && !fieldType.getAllowedValues().isEmpty();
        boolean hasFieldTypeBaseType = Objects.nonNull(fieldType.getBaseType());
        if (isTypeNameBuiltInType && hasFieldTypeBaseType && hasFieldTypeAllowedValues) {
            Type baseType = DMNUtils.getRootType((BaseDMNTypeImpl)fieldType.getBaseType());
            return Objects.equals(typeName, baseType.getName());
        }
        return false;
    }

    private boolean isConstraintRemoved(String typeName, DMNType factType, DMNType fieldType) {
        boolean hasFieldTypeAllowedValues = fieldType.getAllowedValues() != null && !fieldType.getAllowedValues().isEmpty();
        boolean hasFieldTypeBaseType = Objects.nonNull(fieldType.getBaseType());
        boolean isTypeNameFactTypeField = factType.getFields().containsKey(typeName);
        if (!hasFieldTypeBaseType && !hasFieldTypeAllowedValues && isTypeNameFactTypeField) {
            DMNType typeNameDMNType = (DMNType)factType.getFields().get(typeName);
            return Objects.equals(fieldType.getNamespace(), typeNameDMNType.getNamespace());
        }
        return false;
    }

    protected DMNModel getDMNModel(KieContainer kieContainer, String dmnPath) {
        return DMNSimulationUtils.extractDMNModel((DMNRuntime)DMNSimulationUtils.extractDMNRuntime((KieContainer)kieContainer), (String)dmnPath);
    }
}

