/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.elasticsearch.common.SecureRandomHolder;

public class MacAddressProvider {
    private static byte[] getMacAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        if (en != null) {
            while (en.hasMoreElements()) {
                byte[] address;
                NetworkInterface nint = en.nextElement();
                if (nint.isLoopback() || !MacAddressProvider.isValidAddress(address = nint.getHardwareAddress())) continue;
                return address;
            }
        }
        return null;
    }

    private static boolean isValidAddress(byte[] address) {
        if (address == null || address.length != 6) {
            return false;
        }
        for (byte b : address) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] getSecureMungedAddress() {
        byte[] address = null;
        try {
            address = MacAddressProvider.getMacAddress();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!MacAddressProvider.isValidAddress(address)) {
            address = MacAddressProvider.constructDummyMulticastAddress();
        }
        byte[] mungedBytes = new byte[6];
        SecureRandomHolder.INSTANCE.nextBytes(mungedBytes);
        for (int i = 0; i < 6; ++i) {
            int n = i;
            mungedBytes[n] = (byte)(mungedBytes[n] ^ address[i]);
        }
        return mungedBytes;
    }

    private static byte[] constructDummyMulticastAddress() {
        byte[] dummy = new byte[6];
        SecureRandomHolder.INSTANCE.nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 1);
        return dummy;
    }
}

