/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;

public class FlatVariableScopeTest {
    private FlatVariableScope tested;
    private String scope = "scope";
    private String id = "id";
    private String type = "type";

    @Before
    public void setUp() {
        this.tested = new FlatVariableScope();
    }

    @Test
    public void declareAndlookup() {
        this.tested.declare(this.scope, this.id, this.type);
        Optional lookup = this.tested.lookup(this.id);
        VariableScope.Variable variable = (VariableScope.Variable)lookup.get();
        Assert.assertEquals((Object)this.scope, (Object)variable.getParentScopeId());
        Assert.assertEquals((Object)Ids.item((String)this.id), (Object)variable.getTypeDeclaration().getId());
        Assert.assertEquals((Object)this.type, (Object)variable.getTypeDeclaration().getStructureRef());
    }

    @Test
    public void lookupNotFound() {
        Optional variable = this.tested.lookup(UUID.randomUUID().toString());
        Assert.assertFalse((boolean)variable.isPresent());
    }
}

