/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseThrowingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class ThrowingIntermediateEventTest<T extends BaseThrowingIntermediateEvent>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final boolean HAS_INCOME_EDGE = true;
    static final boolean HAS_NO_INCOME_EDGE = false;
    static final int ZERO_OUTGOING_EDGES = 0;
    static final int TWO_OUTGOING_EDGES = 2;
    private Diagram<Graph, Metadata> diagram;
    private Diagram<Graph, Metadata> roundTripDiagram;

    public Diagram<Graph, Metadata> getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram<Graph, Metadata> diagram) {
        this.diagram = diagram;
    }

    public Diagram<Graph, Metadata> getRoundTripDiagram() {
        return this.roundTripDiagram;
    }

    public void setRoundTripDiagram(Diagram<Graph, Metadata> diagram) {
        this.roundTripDiagram = diagram;
    }

    ThrowingIntermediateEventTest() throws Exception {
        this.marshallDiagramWithNewMarshaller();
    }

    private void marshallDiagramWithNewMarshaller() throws Exception {
        this.setDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnThrowingIntermediateEventFilePath()));
        this.setRoundTripDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(this.marshaller.marshall(this.getDiagram()))));
    }

    @Test
    public void testMarshallTopLevelEventFilledProperties() {
        for (String eventId : this.getFilledTopLevelEventIds()) {
            this.checkEventMarshalling(eventId, false, 0);
        }
    }

    @Test
    public void testMarshallTopLevelEventEmptyProperties() {
        this.checkEventMarshalling(this.getEmptyTopLevelEventId(), false, 0);
    }

    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() {
        for (String eventId : this.getFilledSubprocessLevelEventIds()) {
            this.checkEventMarshalling(eventId, false, 0);
        }
    }

    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventId(), false, 0);
    }

    @Test
    public void testMarshallTopLevelEventWithEdgesFilledProperties() {
        for (String eventId : this.getFilledTopLevelEventWithEdgesIds()) {
            this.checkEventMarshalling(eventId, true, 2);
        }
    }

    @Test
    public void testMarshallTopLevelEventWithEdgesEmptyProperties() {
        this.checkEventMarshalling(this.getEmptyTopLevelEventWithEdgesId(), true, 2);
    }

    @Test
    public void testMarshallSubprocessLevelEventWithEdgesFilledProperties() {
        for (String eventId : this.getFilledSubprocessLevelEventWithEdgesIds()) {
            this.checkEventMarshalling(eventId, true, 2);
        }
    }

    @Test
    public void testMarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventWithEdgesId(), true, 2);
    }

    public abstract void testUnmarshallTopLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyEventProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithEdgesFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEventWithEdgesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() throws Exception;

    abstract String getBpmnThrowingIntermediateEventFilePath();

    abstract Class<T> getThrowingIntermediateEventType();

    abstract String[] getFilledTopLevelEventIds();

    abstract String getEmptyTopLevelEventId();

    abstract String[] getFilledSubprocessLevelEventIds();

    abstract String getEmptySubprocessLevelEventId();

    abstract String[] getFilledTopLevelEventWithEdgesIds();

    abstract String getEmptyTopLevelEventWithEdgesId();

    abstract String[] getFilledSubprocessLevelEventWithEdgesIds();

    abstract String getEmptySubprocessLevelEventWithEdgesId();

    T getThrowingIntermediateNodeById(Diagram<Graph, Metadata> diagram, String id, boolean hasIncomeEdge, int outgoingEdges) {
        Node node = diagram.getGraph().getNode(id);
        Assertions.assertThat((Object)node).isNotNull();
        int incomeEdges = hasIncomeEdge ? 2 : 1;
        Assertions.assertThat((int)node.getInEdges().size()).isEqualTo(incomeEdges);
        Assertions.assertThat((int)node.getOutEdges().size()).isEqualTo(outgoingEdges);
        return (T)((BaseThrowingIntermediateEvent)this.getThrowingIntermediateEventType().cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkEventMarshalling(String nodeID, boolean hasIncomeEdge, int outgoingEdges) {
        Diagram<Graph, Metadata> initialDiagram = this.getDiagram();
        int amountOfNodesInDiagram = this.getNodes(initialDiagram).size();
        Diagram<Graph, Metadata> marshalledDiagram = this.getRoundTripDiagram();
        this.assertDiagram(marshalledDiagram, amountOfNodesInDiagram);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, hasIncomeEdge, outgoingEdges);
    }

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, boolean hasIncomeEdge, int outgoingEdges) {
        T nodeBeforeMarshalling = this.getThrowingIntermediateNodeById(before, nodeId, hasIncomeEdge, outgoingEdges);
        T nodeAfterMarshalling = this.getThrowingIntermediateNodeById(after, nodeId, hasIncomeEdge, outgoingEdges);
        Assertions.assertThat(nodeAfterMarshalling).isEqualTo(nodeBeforeMarshalling);
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assertions.assertThat((Object)generalSet).isNotNull();
        Assertions.assertThat((Object)generalSet.getName()).isNotNull();
        Assertions.assertThat((Object)generalSet.getDocumentation()).isNotNull();
        Assertions.assertThat((String)generalSet.getName().getValue()).isEqualTo(nodeName);
        Assertions.assertThat((String)generalSet.getDocumentation().getValue()).isEqualTo(documentation);
    }

    void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assertions.assertThat((Object)dataIOSet).isNotNull();
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assertions.assertThat((Object)assignmentsInfo).isNotNull();
        Assertions.assertThat((String)assignmentsInfo.getValue()).isEqualTo(value);
    }
}

