/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.event.selection;

import java.util.Optional;
import java.util.function.Function;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;

public class CanvasFocusedShapeEvent
extends AbstractCanvasHandlerEvent<CanvasHandler> {
    private static final int FOCUS_PADDING = 100;
    private final String uuid;

    public CanvasFocusedShapeEvent(CanvasHandler canvasHandler, String uuid) {
        super(canvasHandler);
        this.uuid = uuid;
    }

    public int getX() {
        return this.getShapeX().intValue() - 100;
    }

    public int getY() {
        return this.getShapeY().intValue() - 100;
    }

    private Double getShapeX() {
        return this.getShape(shape -> shape.getShapeView().getShapeX());
    }

    private Double getShapeY() {
        return this.getShape(shape -> shape.getShapeView().getShapeY());
    }

    private Double getShape(Function<Shape, Double> shapeFunction) {
        Object shape = this.getCanvas().getShape(this.uuid);
        return Optional.ofNullable(shape).map(shapeFunction).orElse(100.0);
    }

    private Canvas getCanvas() {
        return this.getCanvasHandler().getCanvas();
    }
}

