/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.backend.builder.core.BaseFileNameResolver;
import org.kie.workbench.common.services.backend.builder.core.BuildMessageBuilder;
import org.kie.workbench.common.services.backend.builder.core.ClassVerifier;
import org.kie.workbench.common.services.backend.builder.core.Handles;
import org.kie.workbench.common.services.backend.builder.core.LRUModuleDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.core.LRUPomModelCache;
import org.kie.workbench.common.services.backend.builder.core.MessageConverter;
import org.kie.workbench.common.services.backend.builder.core.TypeSourceResolver;
import org.kie.workbench.common.services.shared.allowlist.AllowList;
import org.kie.workbench.common.services.shared.allowlist.PackageNameAllowListService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;

public class Builder
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private final GAV projectGAV;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Module project;
    private final Path projectRoot;
    private final IOService ioService;
    private final String projectPrefix;
    private final Handles handles = new Handles();
    private final KieModuleService moduleService;
    private final ProjectImportsService importsService;
    private final List<BuildValidationHelper> buildValidationHelpers;
    private final Map<Path, BuildValidationHelper> nonKieResourceValidationHelpers = new HashMap<Path, BuildValidationHelper>();
    private final Map<Path, List<ValidationMessage>> nonKieResourceValidationHelperMessages = new HashMap<Path, List<ValidationMessage>>();
    private final DirectoryStream.Filter<Path> javaResourceFilter = new JavaFileFilter();
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private final Set<String> javaResources = new HashSet<String>();
    private final Predicate<String> classFilter;
    private KieBuilder kieBuilder;
    private LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache;
    private LRUPomModelCache pomModelCache;
    private PackageNameAllowListService packageNameAllowListService;

    public Builder(Module project, IOService ioService, KieModuleService moduleService, ProjectImportsService importsService, List<BuildValidationHelper> buildValidationHelpers, LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache, LRUPomModelCache pomModelCache, PackageNameAllowListService packageNameAllowListService, Predicate<String> classFilter, KieBuilder kieBuilder, KieFileSystem kieFileSystem) {
        this.project = project;
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.importsService = importsService;
        this.buildValidationHelpers = buildValidationHelpers;
        this.packageNameAllowListService = packageNameAllowListService;
        this.classFilter = classFilter;
        this.projectGAV = project.getPom().getGav();
        this.projectRoot = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
        this.projectPrefix = this.projectRoot.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieBuilder = kieBuilder;
        this.kieFileSystem = kieFileSystem;
        this.dependenciesClassLoaderCache = dependenciesClassLoaderCache;
        this.pomModelCache = pomModelCache;
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)this.projectRoot);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    public Builder(Module project, IOService ioService, KieModuleService moduleService, ProjectImportsService importsService, List<BuildValidationHelper> buildValidationHelpers, LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache, LRUPomModelCache pomModelCache, PackageNameAllowListService packageNameAllowListService, Predicate<String> classFilter) {
        this(project, ioService, moduleService, importsService, buildValidationHelpers, dependenciesClassLoaderCache, pomModelCache, packageNameAllowListService, classFilter, null, KieServices.Factory.get().newKieFileSystem());
    }

    public Builder clone() {
        KieFileSystem kieFileSystemClone = this.kieFileSystemClone();
        KieBuilderImpl kieBuilder = this.kieBuilderClone(kieFileSystemClone);
        return new Builder(this.project, this.ioService, this.moduleService, this.importsService, this.buildValidationHelpers, this.dependenciesClassLoaderCache, this.pomModelCache, this.packageNameAllowListService, this.classFilter, (KieBuilder)kieBuilder, kieFileSystemClone);
    }

    private KieFileSystem kieFileSystemClone() {
        return ((KieFileSystemImpl)this.kieFileSystem).clone();
    }

    private KieBuilderImpl kieBuilderClone(KieFileSystem kieFileSystemClone) {
        KieBuilderImpl kieBuilder = null;
        if (this.kieBuilder != null) {
            kieBuilder = this.createKieBuilder(kieFileSystemClone);
            kieBuilder.setkModule((MemoryKieModule)((KieBuilderImpl)this.kieBuilder).getKieModuleIgnoringErrors());
            kieBuilder.setTrgMfs(((KieFileSystemImpl)kieFileSystemClone).getMfs());
        }
        return kieBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResults build() {
        BuildResults results = new BuildResults(this.projectGAV);
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String msg;
            this.kieBuilder = this.createKieBuilder(this.kieFileSystem);
            try {
                Results results2 = ((InternalKieBuilder)this.kieBuilder).buildAll(this.classFilter).getResults();
                results.addAllBuildMessages(MessageConverter.convertMessages(results2.getMessages(), this.handles));
            }
            catch (LinkageError linkageError) {
                msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, linkageError.getLocalizedMessage());
                logger.warn(msg);
                results.addBuildMessage(BuildMessageBuilder.makeWarningMessage(msg));
            }
            catch (Throwable throwable) {
                msg = throwable.getLocalizedMessage();
                logger.error(msg, throwable);
                results.addBuildMessage(BuildMessageBuilder.makeErrorMessage(msg));
            }
            finally {
                PomModel pomModel = ((KieBuilderImpl)this.kieBuilder).getPomModel();
                if (pomModel != null) {
                    this.pomModelCache.setEntry(this.project, pomModel);
                }
            }
        }
        for (Map.Entry entry : this.nonKieResourceValidationHelpers.entrySet()) {
            org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)((Path)entry.getKey()));
            List validationMessages = ((BuildValidationHelper)entry.getValue()).validate(vfsPath);
            this.nonKieResourceValidationHelperMessages.put((Path)entry.getKey(), validationMessages);
            results.addAllBuildMessages(MessageConverter.convertValidationMessages(validationMessages));
        }
        Path nioExternalImportsPath = this.projectRoot.resolve("project.imports");
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.importsService.load(path);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                String fullyQualifiedClassName = item.getType();
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                }
                catch (ClassNotFoundException cnfe) {
                    logger.warn(cnfe.getMessage());
                    String msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, fullyQualifiedClassName);
                    results.addBuildMessage(BuildMessageBuilder.makeWarningMessage(msg));
                }
            }
        }
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)this.getKieModuleIgnoringErrors(), (DependencyFilter)DependencyFilter.COMPILE_FILTER);
        this.updateDependenciesClassLoader(this.project, kieModuleMetaData);
        results.addAllBuildMessages(this.verifyClasses(kieModuleMetaData));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResults build(Path resource, InputStream inputStream) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String destinationPath = this.destinationPath(resource);
            Resource inputStreamResource = KieServices.Factory.get().getResources().newInputStreamResource((InputStream)new BufferedInputStream(inputStream));
            this.kieFileSystem.write(destinationPath, inputStreamResource);
        }
        return this.build();
    }

    private List<BuildMessage> verifyClasses(KieModuleMetaData kieModuleMetaData) {
        return new ClassVerifier(kieModuleMetaData, this.getTypeSourceResolver(kieModuleMetaData)).verify(this.getAllowList(kieModuleMetaData));
    }

    private AllowList getAllowList(KieModuleMetaData kieModuleMetaData) {
        return this.packageNameAllowListService.filterPackageNames(this.project, kieModuleMetaData.getPackages());
    }

    private KieBuilderImpl createKieBuilder(KieFileSystem kieFileSystem) {
        KieBuilderImpl kieBuilder = (KieBuilderImpl)this.kieServices.newKieBuilder(kieFileSystem);
        PomModel pomModel = (PomModel)this.pomModelCache.getEntry(this.project);
        if (pomModel != null) {
            kieBuilder.setPomModel(pomModel);
        }
        return kieBuilder;
    }

    private void updateDependenciesClassLoader(Module project, KieModuleMetaData kieModuleMetaData) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(project.getPomXMLPath());
        if (kieModule != null) {
            this.dependenciesClassLoaderCache.setDependenciesClassLoader(kieModule, LRUModuleDependenciesClassLoaderCache.buildClassLoader(kieModule, kieModuleMetaData));
        }
    }

    public IncrementalBuildResults addResource(Path resource) {
        IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
        if (this.ioService.exists(resource)) {
            results = this.addResource(resource, this.ioService.newInputStream(resource, new OpenOption[0]));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IncrementalBuildResults addResource(Path resource, InputStream inputStream) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults(this.projectGAV);
        }
        this.checkAFullBuildHasBeenPerformed();
        IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
            results.addAllAddedMessages(MessageConverter.convertValidationMessages(addedValidationMessages));
            results.addAllRemovedMessages(MessageConverter.convertValidationMessages(this.nonKieResourceValidationHelperMessages.remove(resource)));
            this.nonKieResourceValidationHelpers.put(resource, validator);
            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            this.addNewResource(resource, inputStream);
            this.buildIncrementally(results, this.destinationPath(resource));
        }
        return results;
    }

    private void addNewResource(Path path, InputStream inputStream) {
        String destinationPath = this.destinationPath(path);
        Resource inputStreamResource = KieServices.Factory.get().getResources().newInputStreamResource((InputStream)new BufferedInputStream(inputStream));
        this.kieFileSystem.write(destinationPath, inputStreamResource);
        this.handles.put(BaseFileNameResolver.getBaseFileName(destinationPath), Paths.convert((Path)path));
        this.addJavaClass(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults deleteResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        this.checkAFullBuildHasBeenPerformed();
        IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            this.nonKieResourceValidationHelpers.remove(resource);
            results.addAllRemovedMessages(MessageConverter.convertValidationMessages(this.nonKieResourceValidationHelperMessages.remove(resource)));
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            this.removeResource(resource);
            this.buildIncrementally(results, this.destinationPath(resource));
        }
        return results;
    }

    private void removeResource(Path resource) {
        this.kieFileSystem.delete(new String[]{this.destinationPath(resource)});
        this.removeJavaClass(resource);
    }

    private String destinationPath(Path resource) {
        String destinationPath = EncodingUtil.decode((String)resource.toUri().toString().substring(this.projectPrefix.length()));
        if (destinationPath.startsWith("/")) {
            return destinationPath.substring(1);
        }
        return destinationPath;
    }

    public IncrementalBuildResults updateResource(Path resource) {
        return this.addResource(resource);
    }

    public IncrementalBuildResults updateResource(Path resource, InputStream inputStream) {
        return this.addResource(resource, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults applyBatchResourceChanges(Map<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        this.checkAFullBuildHasBeenPerformed();
        HashSet<String> changedFilesKieBuilderPaths = new HashSet<String>();
        ArrayList<ValidationMessage> nonKieResourceValidatorAddedMessages = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> nonKieResourceValidatorRemovedMessages = new ArrayList<ValidationMessage>();
        IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            for (Map.Entry<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> pathCollectionEntry : changes.entrySet()) {
                for (ResourceChange change : pathCollectionEntry.getValue()) {
                    ResourceChangeType type = change.getType();
                    Path resource = Paths.convert((org.uberfire.backend.vfs.Path)pathCollectionEntry.getKey());
                    PortablePreconditions.checkNotNull((String)"type", (Object)type);
                    PortablePreconditions.checkNotNull((String)"Builder.resource\u00a7", (Object)resource);
                    String destinationPath = this.destinationPath(resource);
                    changedFilesKieBuilderPaths.add(destinationPath);
                    switch (type) {
                        case ADD: 
                        case UPDATE: {
                            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) break;
                            this.update(nonKieResourceValidatorAddedMessages, nonKieResourceValidatorRemovedMessages, resource);
                            break;
                        }
                        case DELETE: 
                        case RENAME: {
                            this.delete(nonKieResourceValidatorRemovedMessages, resource);
                        }
                    }
                }
            }
            this.buildIncrementally(results, this.toArray(changedFilesKieBuilderPaths));
        }
        results.addAllAddedMessages(MessageConverter.convertValidationMessages(nonKieResourceValidatorAddedMessages));
        results.addAllRemovedMessages(MessageConverter.convertValidationMessages(nonKieResourceValidatorRemovedMessages));
        return results;
    }

    private String[] toArray(Set<String> stringSet) {
        String[] stringArray = new String[stringSet.size()];
        stringSet.toArray(stringArray);
        return stringArray;
    }

    private void update(List<ValidationMessage> nonKieResourceValidatorAddedMessages, List<ValidationMessage> nonKieResourceValidatorRemovedMessages, Path resource) {
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            List<ValidationMessage> removedValidationMessages;
            List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
            if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : addedValidationMessages) {
                    nonKieResourceValidatorAddedMessages.add(validationMessage);
                }
            }
            if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : removedValidationMessages) {
                    nonKieResourceValidatorRemovedMessages.add(validationMessage);
                }
            }
            this.nonKieResourceValidationHelpers.put(resource, validator);
            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
        }
        this.addNewResource(resource, this.ioService.newInputStream(resource, new OpenOption[0]));
    }

    private void delete(List<ValidationMessage> nonKieResourceValidatorRemovedMessages, Path resource) {
        this.nonKieResourceValidationHelpers.remove(resource);
        List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
        if (removedValidationMessages != null && !removedValidationMessages.isEmpty()) {
            for (ValidationMessage validationMessage : removedValidationMessages) {
                nonKieResourceValidatorRemovedMessages.add(validationMessage);
            }
        }
        this.removeResource(resource);
    }

    private void buildIncrementally(IncrementalBuildResults results, String ... destinationPath) {
        try {
            IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(Message.Level.WARNING, destinationPath).build();
            results.addAllAddedMessages(MessageConverter.convertMessages(incrementalResults.getAddedMessages(), this.handles));
            results.addAllRemovedMessages(MessageConverter.convertMessages(incrementalResults.getRemovedMessages(), this.handles));
            for (Message message : incrementalResults.getRemovedMessages()) {
                this.handles.remove("src/main/resources/" + BaseFileNameResolver.getBaseFileName(message.getPath()));
            }
        }
        catch (LinkageError e) {
            String msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
            logger.warn(msg);
            results.addAddedMessage(BuildMessageBuilder.makeWarningMessage(msg));
        }
        catch (Throwable e) {
            String msg = e.getLocalizedMessage();
            logger.error(msg, e);
            results.addAddedMessage(BuildMessageBuilder.makeErrorMessage(msg));
        }
    }

    private void checkAFullBuildHasBeenPerformed() {
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.builder.KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.kieBuilder.getKieModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.builder.KieModule getKieModuleIgnoringErrors() {
        if (!this.isBuilt()) {
            this.build();
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
        }
    }

    public KieModuleMetaData getKieModuleMetaDataIgnoringErrors() {
        return KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)this.getKieModuleIgnoringErrors(), (DependencyFilter)DependencyFilter.COMPILE_FILTER);
    }

    public TypeSourceResolver getTypeSourceResolver(KieModuleMetaData kieModuleMetaData) {
        return new TypeSourceResolver(kieModuleMetaData, this.javaResources);
    }

    public KieContainer getKieContainer() {
        BuildResults results = null;
        if (!this.isBuilt()) {
            results = this.build();
        } else {
            results = new BuildResults();
            results.addAllBuildMessages(MessageConverter.convertMessages(this.kieBuilder.getResults().getMessages(), this.handles));
        }
        if (results.getErrorMessages().isEmpty()) {
            org.kie.api.builder.KieModule kieModule = this.kieBuilder.getKieModule();
            ReleaseId releaseId = kieModule.getReleaseId();
            KieModuleKieProject kieProject = new KieModuleKieProject((InternalKieModule)this.kieBuilder.getKieModule(), null);
            KieContainerImpl kieContainer = new KieContainerImpl((KieProject)kieProject, KieServices.Factory.get().getRepository(), releaseId);
            return kieContainer;
        }
        return null;
    }

    public boolean isBuilt() {
        return this.kieBuilder != null;
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.dotFileFilter.accept((Object)path)) continue;
            BuildValidationHelper validator = this.getBuildValidationHelper(path);
            if (validator != null) {
                this.nonKieResourceValidationHelpers.put(path, validator);
            }
            this.addNewResource(path, this.ioService.newInputStream(path, new OpenOption[0]));
        }
    }

    private void addJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.moduleService.resolvePackage(Paths.convert((Path)path));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    private BuildValidationHelper getBuildValidationHelper(Path nioResource) {
        for (BuildValidationHelper validator : this.buildValidationHelpers) {
            org.uberfire.backend.vfs.Path resource;
            if (!validator.accepts(resource = Paths.convert((Path)nioResource))) continue;
            return validator;
        }
        return null;
    }

    KieFileSystem getKieFileSystem() {
        return this.kieFileSystem;
    }
}

