/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ItemNameReader;

public class InputAssignmentReader {
    private final AssociationDeclaration associationDeclaration;

    public static InputAssignmentReader fromAssociation(DataInputAssociation in) {
        List sourceList = in.getSourceRef();
        List assignmentList = in.getAssignment();
        String targetName = ((DataInput)in.getTargetRef()).getName();
        if (AssignmentsInfos.isReservedIdentifier(targetName)) {
            return null;
        }
        if (!sourceList.isEmpty()) {
            return new InputAssignmentReader((ItemAwareElement)sourceList.get(0), targetName);
        }
        if (!assignmentList.isEmpty()) {
            return new InputAssignmentReader((Assignment)assignmentList.get(0), targetName);
        }
        throw new IllegalArgumentException("Cannot find SourceRef or Assignment for Target " + targetName);
    }

    InputAssignmentReader(Assignment assignment, String targetName) {
        FormalExpression from = (FormalExpression)assignment.getFrom();
        String body = from.getBody();
        String encodedBody = this.encode(body);
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.FromTo, encodedBody, targetName);
    }

    InputAssignmentReader(ItemAwareElement source, String targetName) {
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.SourceTarget, ItemNameReader.from(source).getName(), targetName);
    }

    private String encode(String body) {
        return Optional.ofNullable(body).filter(b -> !"null".equals(b)).map(b -> {
            try {
                return URLEncoder.encode(b, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(body, e);
            }
        }).orElse("");
    }

    public AssociationDeclaration getAssociationDeclaration() {
        return this.associationDeclaration;
    }
}

