/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.impl;

import java.util.HashSet;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceSettings;
import org.kie.workbench.common.screens.datasource.management.backend.core.DefaultDriverInitializer;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefSerializer;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefValidator;
import org.kie.workbench.common.screens.datasource.management.util.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DefaultDriverInitializerImpl
implements DefaultDriverInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDriverInitializerImpl.class);
    private static final String PREFIX = "driverDef";
    private static final String UUID = "driverDef.uuid";
    private static final String NAME = "driverDef.name";
    private static final String DRIVER_CLASS = "driverDef.driverClass";
    private static final String GROUP_ID = "driverDef.groupId";
    private static final String ARTIFACT_ID = "driverDef.artifactId";
    private static final String VERSION = "driverDef.version";
    public static final String DISABLE_DEFAULT_DRIVERS = "datasource.management.disableDefaultDrivers";
    private IOService ioService;
    private DataSourceServicesHelper serviceHelper;
    private CommentedOptionFactory optionsFactory;
    private DriverDefValidator driverDefValidator = new DriverDefValidator();

    public DefaultDriverInitializerImpl() {
    }

    @Inject
    public DefaultDriverInitializerImpl(@Named(value="ioStrategy") IOService ioService, DataSourceServicesHelper serviceHelper, CommentedOptionFactory optionsFactory) {
        this.ioService = ioService;
        this.serviceHelper = serviceHelper;
        this.optionsFactory = optionsFactory;
    }

    @Override
    public void initializeDefaultDrivers() {
        boolean disableDefaultDrivers = this.areDriversDisabledByDefault();
        if (disableDefaultDrivers) {
            logger.debug("Default drivers initialization was disabled by using the datasource.management.disableDefaultDrivers configuration property.");
        } else {
            this.initializeFromSystemProperties();
            this.initializeFromConfigFile();
        }
    }

    boolean areDriversDisabledByDefault() {
        return Boolean.valueOf(ServiceUtil.getManagedProperty(DataSourceSettings.getInstance().getProperties(), DISABLE_DEFAULT_DRIVERS, "true"));
    }

    protected void initializeFromSystemProperties() {
        this.initializeFromProperties(System.getProperties());
    }

    protected void initializeFromConfigFile() {
        this.initializeFromProperties(DataSourceSettings.getInstance().getProperties());
    }

    private void initializeFromProperties(Properties properties) {
        HashSet<String> driverCodes = new HashSet<String>();
        Path globalPath = Paths.convert((org.uberfire.backend.vfs.Path)this.serviceHelper.getGlobalDataSourcesContext());
        for (String propertyName : properties.stringPropertyNames()) {
            if (propertyName.length() <= UUID.length() || !propertyName.startsWith("driverDef.uuid.")) continue;
            driverCodes.add(propertyName.substring(UUID.length() + 1, propertyName.length()));
        }
        for (String driverCode : driverCodes) {
            DriverDef driverDef = new DriverDef();
            driverDef.setUuid(this.getDriverParam(properties, UUID, driverCode));
            driverDef.setName(this.getDriverParam(properties, NAME, driverCode));
            driverDef.setDriverClass(this.getDriverParam(properties, DRIVER_CLASS, driverCode));
            driverDef.setGroupId(this.getDriverParam(properties, GROUP_ID, driverCode));
            driverDef.setArtifactId(this.getDriverParam(properties, ARTIFACT_ID, driverCode));
            driverDef.setVersion(this.getDriverParam(properties, VERSION, driverCode));
            if (this.driverDefValidator.validate(driverDef)) {
                Path targetPath = globalPath.resolve(driverDef.getName() + ".driver");
                try {
                    if (this.ioService.exists(targetPath)) continue;
                    String source = DriverDefSerializer.serialize(driverDef);
                    this.serviceHelper.getDefRegistry().setEntry(Paths.convert((Path)targetPath), driverDef);
                    this.ioService.write(targetPath, source, new OpenOption[]{this.optionsFactory.makeCommentedOption("system generated driver")});
                }
                catch (Exception e) {
                    this.serviceHelper.getDefRegistry().invalidateCache(Paths.convert((Path)targetPath));
                    logger.error("It was not possible to write driver definition {} in path {}. ", (Object)driverDef, (Object)targetPath);
                }
                continue;
            }
            logger.warn("Driver will be skipped due to invalid or uncompleted properties {}.", (Object)driverCode);
        }
    }

    private String getDriverParam(Properties properties, String propertyName, String driverCode) {
        return properties.getProperty(propertyName + "." + driverCode);
    }
}

