/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.designer.server.indexing.bpmn2.DesignerProcessDataEventListener;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class BPMN2FileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2FileIndexer.class);
    private static final SemanticModules modules = new SemanticModules();
    @Inject
    protected Bpmn2TypeDefinition bpmn2TypeDefinition;
    @Inject
    protected ModuleClassLoaderHelper classLoaderHelper;

    public boolean supportsPath(Path path) {
        return this.bpmn2TypeDefinition.accept(Paths.convert((Path)path));
    }

    protected DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieModule module = (KieModule)this.moduleService.resolveModule(Paths.convert((Path)path));
        if (module == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": module could not be resolved.");
            return null;
        }
        DefaultIndexBuilder builder = this.getIndexBuilder(path, (Module)module);
        String bpmnStr = this.ioService.readAllString(path);
        ClassLoader projectClassLoader = this.getProjectClassLoader(module);
        XmlProcessReader xmlReader = new XmlProcessReader(modules, projectClassLoader);
        List processes = xmlReader.read((Reader)new StringReader(bpmnStr));
        if (processes != null) {
            try {
                ArrayList processDataList = new ArrayList();
                processes.forEach(process -> {
                    ProcessValidationError[] errors;
                    DesignerProcessDataEventListener processData = (DesignerProcessDataEventListener)process.getMetaData().get("ProcessInfoCollector");
                    processDataList.add(processData);
                    logger.info("Validating process with id: " + process.getId());
                    for (ProcessValidationError error : errors = RuleFlowProcessValidator.getInstance().validateProcess((RuleFlowProcess)process)) {
                        logger.warn("Process validation error: " + error.getMessage());
                    }
                    xmlReader.getProcessBuildData().onBuildComplete(process);
                });
                for (DesignerProcessDataEventListener processData : processDataList) {
                    this.addReferencedResourcesToIndexBuilder(builder, processData);
                    builder.setPackageName(processData.getProcess().getPackageName());
                }
            }
            catch (Throwable t) {
                logger.warn("Exception during indexing: " + t.getMessage());
            }
        } else {
            logger.warn("No process was found in file: " + path.toUri());
        }
        return builder;
    }

    protected ClassLoader getProjectClassLoader(KieModule module) {
        return this.classLoaderHelper.getModuleClassLoader(module);
    }

    protected DefaultIndexBuilder getIndexBuilder(Path path, Module module) {
        Package pkg = this.moduleService.resolvePackage(Paths.convert((Path)path));
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), module, pkg);
    }

    static {
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
    }
}

