/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.ConfigBasedPipeline;
import org.guvnor.ala.pipeline.ConfigBasedPipelineBuilder;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineConfigStage;
import org.guvnor.ala.pipeline.impl.ConfigBasedPipelineImpl;
import org.guvnor.ala.pipeline.impl.PipelineConfigImpl;

public final class PipelineFactory {
    private PipelineFactory() {
    }

    public static ConfigBasedPipelineBuilder newBuilder() {
        return new ConfigBasedPipelineBuilder(){
            private final List<PipelineConfigStage> configStages = new ArrayList<PipelineConfigStage>();

            @Override
            public ConfigBasedPipelineBuilder addConfigStage(String name, Config config) {
                this.configStages.add(new PipelineConfigStage(name, config));
                return this;
            }

            @Override
            public ConfigBasedPipelineBuilder addConfigStage(PipelineConfigStage configStage) {
                this.configStages.add(configStage);
                return this;
            }

            @Override
            public ConfigBasedPipeline buildAs(String name) {
                return new ConfigBasedPipelineImpl(new PipelineConfigImpl(name, this.configStages));
            }
        };
    }

    public static ConfigBasedPipeline newPipeline(PipelineConfig pipelineConfig) {
        return new ConfigBasedPipelineImpl(pipelineConfig);
    }
}

