/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.migration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.api.FileSystemUtils;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.mvp.Command;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Startup
public class DashbuilderDataMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashbuilderDataMigration.class);
    private IOService ioService;
    private FileSystem datasetsFS;
    private FileSystem pluginsFS;
    private FileSystem perspectivesFS;
    private FileSystem navigationFS;

    public DashbuilderDataMigration() {
    }

    @Inject
    public DashbuilderDataMigration(@Named(value="ioStrategy") IOService ioService, @Named(value="datasetsFS") FileSystem datasetsFS, @Named(value="pluginsFS") FileSystem pluginsFS, @Named(value="perspectivesFS") FileSystem perspectivesFS, @Named(value="navigationFS") FileSystem navigationFS) {
        this.ioService = ioService;
        this.datasetsFS = datasetsFS;
        this.pluginsFS = pluginsFS;
        this.perspectivesFS = perspectivesFS;
        this.navigationFS = navigationFS;
    }

    @PostConstruct
    protected void init() {
        if (this.isMigrationEnabled()) {
            this.runWithLock(() -> {
                this.migrateDatasets();
                this.migratePerspectives();
                this.migrateNavigation();
            });
        }
    }

    protected boolean isMigrationEnabled() {
        return FileSystemUtils.isGitDefaultFileSystem();
    }

    private void migrateDatasets() {
        FileSystem oldDatasetsFS = this.lookupFileSystem(SpacesAPI.DEFAULT_SPACE, "datasets");
        this.migrateDatasets(oldDatasetsFS, this.datasetsFS);
        this.cleanupFileSystem(oldDatasetsFS);
    }

    private FileSystem lookupFileSystem(Space space, String name) {
        FileSystem fs;
        URI uri = new SpacesAPIImpl().resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, space, name);
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("init", Boolean.TRUE);
        env.put("internal", Boolean.TRUE);
        try {
            fs = this.ioService.newFileSystem(uri, env);
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
        }
        return fs;
    }

    private void cleanupFileSystem(FileSystem fs) {
        Path root = this.getRoot(fs);
        if (root != null && fs instanceof JGitFileSystem) {
            try {
                Path fsPath = fs.getPath("", new String[0]);
                Files.delete((Path)fsPath, (DeleteOption[])new DeleteOption[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to remove the datasets git repository.");
                LOGGER.debug("Error during dashbuilder migration", (Throwable)e);
            }
        }
    }

    private void migratePerspectives() {
        this.migratePerspectives(this.pluginsFS, this.perspectivesFS);
    }

    private void migrateNavigation() {
        this.migrateNavigation(this.pluginsFS, this.navigationFS);
    }

    public void migrateDatasets(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate datasets");
        this.migrate(sourceFS, targetFS, path -> !path.getFileName().toString().equals("readme.md"));
    }

    public void migratePerspectives(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate perspectives");
        this.migrate(sourceFS, targetFS, path -> path.getFileName().toString().startsWith("perspective_layout"));
    }

    public void migrateNavigation(FileSystem sourceFS, FileSystem targetFS) {
        LOGGER.info("attempt to migrate navigation");
        this.migrate(sourceFS, targetFS, path -> path.getFileName().toString().equals("navtree.json"));
    }

    private void migrate(FileSystem sourceFS, FileSystem targetFS, final Predicate<Path> predicate) {
        Path sourceRoot = this.getRoot(sourceFS);
        final Path targetRoot = this.getRoot(targetFS);
        if (sourceRoot == null) {
            LOGGER.info("source does not exists");
            return;
        }
        if (targetRoot == null) {
            LOGGER.error("target does not exists");
            return;
        }
        LOGGER.info("moving from " + sourceFS.getName() + " to " + targetFS.getName());
        Files.walkFileTree((Path)sourceRoot, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                PortablePreconditions.checkNotNull((String)"file", (Object)path);
                PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                Path targetPath = targetRoot.resolve(path.toString());
                if (!predicate.test(path)) {
                    LOGGER.debug("skip file " + path.toString());
                } else if (DashbuilderDataMigration.this.ioService.exists(targetPath)) {
                    LOGGER.debug("file " + path.toString() + " already exists on target");
                    Files.delete((Path)path, (DeleteOption[])new DeleteOption[0]);
                } else {
                    LOGGER.debug("moving file " + path.toString());
                    Files.copy((Path)path, (Path)targetPath, (CopyOption[])new CopyOption[0]);
                    Files.delete((Path)path, (DeleteOption[])new DeleteOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRoot(FileSystem fileSystem) {
        try {
            return (Path)fileSystem.getRootDirectories().iterator().next();
        }
        catch (Exception e) {
            LOGGER.debug("could not get filesystem root", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWithLock(Command command) {
        String lockName = "data-migration.lock";
        String markerName = "data-migration.done";
        TimeUnit lastAccessTimeUnit = TimeUnit.SECONDS;
        int lastAccessThreshold = 1;
        File dir = this.navigationFS.getPath("/", new String[0]).toFile().getParentFile();
        File marker = new File(dir, markerName);
        FileSystemLock lock = FileSystemLockManager.getInstance().getFileSystemLock(dir, lockName, lastAccessTimeUnit, (long)lastAccessThreshold);
        try {
            lock.lock();
            if (!marker.exists()) {
                marker.createNewFile();
                command.execute();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }
}

