/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.forms.backend.service.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.bpmn2.Definitions;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.authoring.Authoring;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.forms.backend.gen.FormGenerationModelProviders;
import org.kie.workbench.common.stunner.forms.backend.service.FormDefinitionGenerator;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@Dependent
public class FormDefinitionGeneratorImpl
implements FormDefinitionGenerator {
    private static Logger LOGGER = Logger.getLogger(FormDefinitionGeneratorImpl.class.getName());
    private final FormGenerationModelProviders providers;
    private final IOService ioService;
    private final BPMNFormModelGenerator bpmnFormModelGenerator;
    private final FormDefinitionSerializer serializer;
    private final BPMNFormGeneratorService<org.uberfire.backend.vfs.Path> bpmnFormGeneratorService;

    @Inject
    public FormDefinitionGeneratorImpl(FormGenerationModelProviders providers, @Named(value="ioStrategy") IOService ioService, BPMNFormModelGenerator bpmnFormModelGenerator, FormDefinitionSerializer serializer, @Authoring BPMNFormGeneratorService<org.uberfire.backend.vfs.Path> bpmnFormGeneratorService) {
        this.providers = providers;
        this.ioService = ioService;
        this.bpmnFormModelGenerator = bpmnFormModelGenerator;
        this.serializer = serializer;
        this.bpmnFormGeneratorService = bpmnFormGeneratorService;
    }

    @Override
    public void generateProcessForm(Diagram diagram) {
        try {
            LOGGER.finest("Generating form for process ");
            Definitions definitions = this.toDefinitions(diagram);
            org.uberfire.backend.vfs.Path path = diagram.getMetadata().getPath();
            BusinessProcessFormModel formModel = this.bpmnFormModelGenerator.generateProcessFormModel(definitions, path);
            this.createFormForModel((JBPMFormModel)formModel, Paths.convert((org.uberfire.backend.vfs.Path)path));
        }
        catch (Exception ex) {
            LOGGER.severe("Error generating process form");
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void generateSelectedForms(Diagram diagram, String ... taskIds) {
        if (null != taskIds) {
            this.generateSelectedFormsForTasks(diagram, taskIds);
        }
    }

    private void generateSelectedFormsForTasks(Diagram diagram, String ... taskIds) {
        try {
            String idsRaw = Arrays.stream(taskIds).collect(Collectors.joining(","));
            LOGGER.finest("Generating form for tasks " + idsRaw);
            org.uberfire.backend.vfs.Path path = diagram.getMetadata().getPath();
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            this.ioService.startBatch(this.ioService.getFileSystem(nioPath.toUri()));
            Definitions definitions = this.toDefinitions(diagram);
            for (String taskId : taskIds) {
                TaskFormModel formModel = this.bpmnFormModelGenerator.generateTaskFormModel(definitions, taskId, path);
                this.createFormForModel((JBPMFormModel)formModel, nioPath);
            }
        }
        catch (Exception ex) {
            LOGGER.severe("Error generating task forms");
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    @Override
    public void generateAllForms(Diagram diagram) {
        try {
            LOGGER.finest("Generating all forms");
            org.uberfire.backend.vfs.Path path = diagram.getMetadata().getPath();
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            this.ioService.startBatch(this.ioService.getFileSystem(nioPath.toUri()));
            Definitions definitions = this.toDefinitions(diagram);
            BusinessProcessFormModel processFormModel = this.bpmnFormModelGenerator.generateProcessFormModel(definitions, path);
            this.createFormForModel((JBPMFormModel)processFormModel, nioPath);
            List taskFormModels = this.bpmnFormModelGenerator.generateTaskFormModels(definitions, path);
            for (TaskFormModel taskFormModel : taskFormModels) {
                this.createFormForModel((JBPMFormModel)taskFormModel, nioPath);
            }
        }
        catch (Exception ex) {
            LOGGER.severe("Error generating all diagram forms");
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public void createFormForModel(JBPMFormModel formModel, Path path) {
        if (formModel == null) {
            LOGGER.severe("Impossible to create form for empty model");
            throw new IllegalArgumentException("Impossible to create form for empty model");
        }
        Path nioFormPath = path.getParent().resolve(formModel.getFormName() + ".frm");
        FormDefinition form = this.bpmnFormGeneratorService.generateForms(formModel, (Object)Paths.convert((Path)nioFormPath)).getRootForm();
        if (!this.ioService.exists(nioFormPath)) {
            this.ioService.createFile(nioFormPath, new FileAttribute[0]);
        }
        this.ioService.write(nioFormPath, this.serializer.serialize(form), new OpenOption[0]);
    }

    protected Definitions toDefinitions(Diagram diagram) throws IOException {
        return (Definitions)this.providers.getModelProvider(diagram).generate(diagram);
    }
}

