/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.i18n.ResourceHelper;

public class BundleTag
extends TagSupport {
    private String _baseName = null;
    private String _localeAttribute = null;
    private Locale _locale = null;
    private boolean _changeResponseLocale = true;
    private ResourceBundle _bundle = null;
    private int _scope = 1;
    private boolean _debug = false;

    public final void setBaseName(String value) {
        this._baseName = value;
    }

    public final void setDebug(boolean value) {
        this._debug = value;
    }

    public void setLocale(Locale value) {
        this._locale = value;
    }

    public void setLocaleAttribute(String value) {
        this._localeAttribute = value;
    }

    public void setLocaleRef(String value) {
        this._localeAttribute = value;
    }

    public void setScope(String value) throws JspException {
        if (value == null) {
            throw new JspTagException("i18n:bundle tag invalid scope attribute of null");
        }
        if (value.toLowerCase().equals("application")) {
            this._scope = 4;
        } else if (value.toLowerCase().equals("session")) {
            this._scope = 3;
        } else if (value.toLowerCase().equals("request")) {
            this._scope = 2;
        } else if (value.toLowerCase().equals("page")) {
            this._scope = 1;
        } else {
            throw new JspTagException("i18n:bundle tag invalid scope attribute=" + value);
        }
    }

    public void setChangeResponseLocale(boolean value) {
        this._changeResponseLocale = value;
    }

    public void release() {
        super.release();
        this._baseName = null;
        this._localeAttribute = null;
        this._locale = null;
        this._changeResponseLocale = true;
        this._bundle = null;
        this._scope = 1;
        this._debug = false;
    }

    protected final ResourceBundle getBundle() {
        return this._bundle;
    }

    private void findBundle() throws JspException {
        if (this._baseName == null) {
            throw new JspTagException("i18n:bundle tag, a baseName attribute must be specified.");
        }
        Locale locale = this._locale;
        if (locale == null && this._localeAttribute != null) {
            locale = (Locale)this.pageContext.findAttribute(this._localeAttribute);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (locale != null) {
            this._bundle = ResourceBundle.getBundle(this._baseName, locale, cl);
            if (this._debug) {
                ServletContext sc = this.pageContext.getServletContext();
                sc.log("i18n:bundle tag debug: found locale " + locale);
            }
        } else {
            ServletContext sc;
            Enumeration localeEnumerator = this.pageContext.getRequest().getLocales();
            while (localeEnumerator.hasMoreElements()) {
                locale = (Locale)localeEnumerator.nextElement();
                if (this._debug) {
                    sc = this.pageContext.getServletContext();
                    sc.log("i18n:bundle tag debug: enumerating locale = " + locale);
                }
                ResourceBundle test = ResourceBundle.getBundle(this._baseName, locale, cl);
                String language = test.getLocale().getLanguage();
                String country = test.getLocale().getCountry();
                if (test.getLocale().equals(locale)) {
                    this._bundle = test;
                    break;
                }
                if (locale.getLanguage().equals(language)) {
                    if (locale.getCountry().equals(country)) {
                        this._bundle = test;
                        continue;
                    }
                    if (this._bundle != null) continue;
                    this._bundle = test;
                    continue;
                }
                if (!this._debug) continue;
                ServletContext sc2 = this.pageContext.getServletContext();
                sc2.log("i18n:bundle tag requested locale not available: " + locale);
            }
            if (this._bundle == null) {
                this._bundle = ResourceBundle.getBundle(this._baseName);
            }
            if (this._debug) {
                sc = this.pageContext.getServletContext();
                sc.log("i18n:bundle tag debug: bundle (sensed locale) = " + this._bundle);
            }
            if (this._localeAttribute != null) {
                HttpSession session = this.pageContext.getSession();
                session.setAttribute(this._localeAttribute, (Object)this._bundle.getLocale());
            }
        }
    }

    public int doStartTag() throws JspException {
        this._bundle = null;
        this.findBundle();
        if (this._debug) {
            ServletContext sc = this.pageContext.getServletContext();
            sc.log("i18n:bundle tag debug: basename =" + this._baseName);
        }
        if (this.getId() != null) {
            this.pageContext.setAttribute(this.getId(), (Object)this._bundle);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        Locale bundleLocale;
        if (this._changeResponseLocale && (bundleLocale = this._bundle.getLocale()) != null && !"".equals(bundleLocale.getLanguage())) {
            this.pageContext.getResponse().setLocale(bundleLocale);
        }
        ResourceHelper.setBundle(this.pageContext, this._bundle, this._scope);
        return 6;
    }
}

