/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jabber;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JabberDefinitions.wid", name="Jabber", displayName="Jabber", defaultHandler="mvel: new org.jbpm.process.workitem.jabber.JabberWorkItemHandler()", documentation="jabber-workitem/index.html", category="jabber-workitem", icon="Jabber.png", parameters={@WidParameter(name="User"), @WidParameter(name="Password"), @WidParameter(name="Server"), @WidParameter(name="Port"), @WidParameter(name="Service"), @WidParameter(name="Text"), @WidParameter(name="To", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jabber-workitem", version="7.69.0.Final")}, serviceInfo=@WidService(category="Jabber", description="Send message via Jabber", keywords="jabber,im,xmpp,message,send", action=@WidAction(title="Send a message using Jabber"), authinfo=@WidAuth(required=true, params={"user", "password"}, paramsdescription={"Jabber user", "Jabber password"}, referencesite="https://www.jabber.org/")))
public class JabberWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(JabberWorkItemHandler.class);
    private String user;
    private String password;
    private String server;
    private int port;
    private String service;
    private String text;
    private ConnectionConfiguration conf;
    private XMPPConnection connection;
    private List<String> toUsers = new ArrayList<String>();

    public JabberWorkItemHandler(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            this.user = (String)workItem.getParameter("User");
            this.password = (String)workItem.getParameter("Password");
            this.server = (String)workItem.getParameter("Server");
            String portString = (String)workItem.getParameter("Port");
            if (portString != null && !portString.equals("")) {
                this.port = Integer.valueOf((String)workItem.getParameter("Port"));
            }
            this.service = (String)workItem.getParameter("Service");
            this.text = (String)workItem.getParameter("Text");
            String to = (String)workItem.getParameter("To");
            for (String s : to.split(";")) {
                if (s == null || "".equals(s)) continue;
                this.toUsers.add(s);
            }
            if (this.conf == null) {
                this.conf = new ConnectionConfiguration(this.server, this.port, this.service);
            }
            if (this.server != null && !this.server.equals("") && this.port != 0) {
                if (this.connection == null) {
                    this.connection = new XMPPConnection(this.conf);
                }
            } else if (this.connection == null) {
                this.connection = new XMPPConnection(this.service);
            }
            this.connection.connect();
            logger.info("Connected to {}", (Object)this.connection.getHost());
            this.connection.login(this.user, this.password);
            logger.info("Logged in as {}", (Object)this.connection.getUser());
            Presence presence = new Presence(Presence.Type.available);
            this.connection.sendPacket((Packet)presence);
            for (String toUser : this.toUsers) {
                ChatManager chatmanager = this.connection.getChatManager();
                Chat chat = chatmanager.createChat(toUser, null);
                Message msg = new Message(toUser, Message.Type.chat);
                msg.setBody(this.text);
                chat.sendMessage(msg);
                logger.info("Message Sent {}", (Object)msg);
            }
            this.connection.disconnect();
            manager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void setConf(ConnectionConfiguration conf) {
        this.conf = conf;
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }
}

