/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.config.Config;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderRegistryCDI;
import org.dashbuilder.dataprovider.csv.CSVFileStorage;
import org.dashbuilder.dataset.DataSetDefRegistryImpl;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.exception.ExceptionManager;
import org.dashbuilder.scheduler.Scheduler;
import org.dashbuilder.scheduler.SchedulerCDI;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;

@ApplicationScoped
public class DataSetDefRegistryCDI
extends DataSetDefRegistryImpl
implements CSVFileStorage {
    public static final String DATASET_EXT = ".dset";
    public static final String CSV_EXT = ".csv";
    protected int maxCsvLength;
    protected IOService ioService;
    protected ExceptionManager exceptionManager;
    protected UUIDGenerator uuidGenerator;
    protected Event<DataSetDefModifiedEvent> dataSetDefModifiedEvent;
    protected Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent;
    protected Event<DataSetDefRemovedEvent> dataSetDefRemovedEvent;
    protected Event<DataSetStaleEvent> dataSetStaleEvent;
    protected FileSystem fileSystem;
    protected Path root;

    public DataSetDefRegistryCDI() {
    }

    @Inject
    public DataSetDefRegistryCDI(@Config(value="10485760") int maxCsvLength, @Named(value="ioStrategy") IOService ioService, @Named(value="datasetsFS") FileSystem fileSystem, DataSetProviderRegistryCDI dataSetProviderRegistry, SchedulerCDI scheduler, ExceptionManager exceptionManager, Event<DataSetDefModifiedEvent> dataSetDefModifiedEvent, Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent, Event<DataSetDefRemovedEvent> dataSetDefRemovedEvent, Event<DataSetStaleEvent> dataSetStaleEvent) {
        super((DataSetProviderRegistry)dataSetProviderRegistry, (Scheduler)scheduler);
        this.uuidGenerator = DataSetCore.get().getUuidGenerator();
        this.maxCsvLength = maxCsvLength;
        this.ioService = ioService;
        this.fileSystem = fileSystem;
        this.exceptionManager = exceptionManager;
        this.dataSetDefModifiedEvent = dataSetDefModifiedEvent;
        this.dataSetDefRegisteredEvent = dataSetDefRegisteredEvent;
        this.dataSetDefRemovedEvent = dataSetDefRemovedEvent;
        this.dataSetStaleEvent = dataSetStaleEvent;
    }

    @PostConstruct
    public void init() {
        this.initFileSystem();
        this.deleteTempFiles();
        this.registerDataSetDefs();
    }

    public DataSetDefJSONMarshaller getDataSetDefJsonMarshaller() {
        return DataSetCore.get().getDataSetDefJSONMarshaller();
    }

    protected void onDataSetDefStale(DataSetDef def) {
        this.dataSetStaleEvent.fire((Object)new DataSetStaleEvent(def));
    }

    protected void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        this.dataSetDefModifiedEvent.fire((Object)new DataSetDefModifiedEvent(olDef, newDef));
    }

    protected void onDataSetDefRegistered(DataSetDef newDef) {
        this.dataSetDefRegisteredEvent.fire((Object)new DataSetDefRegisteredEvent(newDef));
    }

    protected void onDataSetDefRemoved(DataSetDef oldDef) {
        this.dataSetDefRemovedEvent.fire((Object)new DataSetDefRemovedEvent(oldDef));
    }

    protected void initFileSystem() {
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    protected void registerDataSetDefs() {
        for (DataSetDef def : this.listDataSetDefs()) {
            this.dataSetDefMap.put(def.getUUID(), new DataSetDefRegistryImpl.DataSetDefEntry((DataSetDefRegistryImpl)this, def));
        }
    }

    public org.uberfire.backend.vfs.Path resolveVfsPath(DataSetDef def) {
        return this.convert(this.resolveNioPath(def));
    }

    protected Path resolveNioPath(DataSetDef def) {
        return this.getDataSetsPath().resolve(def.getUUID() + DATASET_EXT);
    }

    public void registerDataSetDef(DataSetDef def, String subjectId, String message) {
        if (def.getUUID() == null) {
            String uuid = this.uuidGenerator.newUuid();
            def.setUUID(uuid);
        }
        if (subjectId == null || message == null) {
            this.ioService.startBatch(this.fileSystem);
        } else {
            this.ioService.startBatch(this.fileSystem, new Option[]{new CommentedOption(subjectId, message)});
        }
        try {
            String defJson = this.getDataSetDefJsonMarshaller().toJsonString(def);
            Path defPath = this.resolveNioPath(def);
            this.ioService.write(defPath, defJson, new OpenOption[0]);
            if (def instanceof CSVDataSetDef) {
                this.saveCSVFile((CSVDataSetDef)def);
            }
            super.registerDataSetDef(def, subjectId, message);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(new Exception("Can't register the data set definition\n" + def, e));
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public DataSetDef removeDataSetDef(String uuid, String subjectId, String message) {
        DataSetDef def = this.getDataSetDef(uuid);
        if (def == null) {
            return null;
        }
        return this.removeDataSetDef(def, subjectId, message);
    }

    public void removeDataSetDef(org.uberfire.backend.vfs.Path path, String subjectId, String comment) {
        DataSetDef def = this.loadDataSetDef(path);
        if (def != null) {
            this.removeDataSetDef(def, subjectId, comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSetDef removeDataSetDef(DataSetDef def, String subjectId, String message) {
        Path defPath = this.resolveNioPath(def);
        if (this.ioService.exists(defPath)) {
            if (subjectId == null || message == null) {
                this.ioService.startBatch(this.fileSystem);
            } else {
                this.ioService.startBatch(this.fileSystem, new Option[]{new CommentedOption(subjectId, message)});
            }
            try {
                this.ioService.deleteIfExists(defPath, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
                if (def instanceof CSVDataSetDef) {
                    this.deleteCSVFile((CSVDataSetDef)def);
                }
            }
            finally {
                this.ioService.endBatch();
            }
        }
        return super.removeDataSetDef(def.getUUID(), subjectId, message);
    }

    public Collection<DataSetDef> listDataSetDefs() {
        final ArrayList<DataSetDef> result = new ArrayList<DataSetDef>();
        if (this.ioService.exists(this.root)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)this.root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().endsWith(DataSetDefRegistryCDI.DATASET_EXT) && attrs.isRegularFile()) {
                            String json = DataSetDefRegistryCDI.this.ioService.readAllString(file);
                            DataSetDef def = DataSetDefRegistryCDI.this.getDataSetDefJsonMarshaller().fromJson(json);
                            result.add(def);
                        }
                    }
                    catch (Exception e) {
                        DataSetDefRegistryCDI.this.log.error("Data set definition read error: " + file.getFileName(), (Throwable)e);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public DataSetDef loadDataSetDef(org.uberfire.backend.vfs.Path path) {
        Path nioPath = this.convert(path);
        if (this.ioService.exists(nioPath)) {
            try {
                String json = this.ioService.readAllString(nioPath);
                DataSetDef def = this.getDataSetDefJsonMarshaller().fromJson(json);
                return def;
            }
            catch (Exception e) {
                String msg = "Error parsing data set JSON definition: " + path.getFileName();
                throw this.exceptionManager.handleException(new Exception(msg, e));
            }
        }
        return null;
    }

    public DataSetDef copyDataSetDef(DataSetDef def, String newName, String subjectId, String message) {
        DataSetDef clone = def.clone();
        clone.setUUID(this.uuidGenerator.newUuid());
        clone.setName(newName);
        if (subjectId == null || message == null) {
            this.ioService.startBatch(this.fileSystem);
        } else {
            this.ioService.startBatch(this.fileSystem, new Option[]{new CommentedOption(subjectId, message)});
        }
        try {
            if (def instanceof CSVDataSetDef) {
                CSVDataSetDef csvDef = (CSVDataSetDef)def;
                CSVDataSetDef csvCloneDef = (CSVDataSetDef)clone;
                Path csvPath = this.resolveCsvPath(csvDef);
                Path cloneCsvPath = this.resolveCsvPath(csvCloneDef);
                this.ioService.copy(csvPath, cloneCsvPath, new CopyOption[0]);
                csvCloneDef.setFilePath(this.convert(cloneCsvPath).toURI());
            }
            String defJson = this.getDataSetDefJsonMarshaller().toJsonString(clone);
            Path clonePath = this.resolveNioPath(clone);
            this.ioService.write(clonePath, defJson, new OpenOption[0]);
            super.registerDataSetDef(clone, subjectId, message);
            DataSetDef dataSetDef = clone;
            return dataSetDef;
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(new Exception("Can't register the data set definition\n" + def, e));
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public Path createTempFile(String fileName) {
        Path tempPath = this.resolveTempPath(fileName);
        return tempPath;
    }

    public void deleteTempFiles() {
        Path tempPath = this.getTempPath();
        if (this.ioService.exists(tempPath)) {
            this.ioService.startBatch(this.fileSystem, new Option[]{new CommentedOption("system", "Delete temporal files")});
            try {
                Files.walkFileTree((Path)tempPath, (FileVisitor)new SimpleFileVisitor<Path>(){

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete((Path)dir, (DeleteOption[])new DeleteOption[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete((Path)file, (DeleteOption[])new DeleteOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    protected Path getDataSetsPath() {
        return this.root.resolve("definitions");
    }

    protected Path getTempPath() {
        return this.root.resolve("tmp");
    }

    protected Path resolveTempPath(String fileName) {
        return this.getTempPath().resolve(fileName);
    }

    protected org.uberfire.backend.vfs.Path convert(Path path) {
        return Paths.convert((Path)path);
    }

    protected Path convert(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }

    public String getCSVString(CSVDataSetDef def) {
        Path nioPath = this.resolveCsvPath(def);
        if (this.ioService.exists(nioPath)) {
            return this.ioService.readAllString(nioPath);
        }
        return null;
    }

    public InputStream getCSVInputStream(CSVDataSetDef def) {
        Path nioPath = this.resolveCsvTempPath(def);
        if (this.ioService.exists(nioPath)) {
            return this.ioService.newInputStream(nioPath, new OpenOption[0]);
        }
        nioPath = this.resolveCsvPath(def);
        if (this.ioService.exists(nioPath)) {
            return this.ioService.newInputStream(nioPath, new OpenOption[0]);
        }
        return null;
    }

    public void deleteCSVFile(CSVDataSetDef def) {
        Path csvPath = this.resolveCsvPath(def);
        if (this.ioService.exists(csvPath)) {
            this.ioService.deleteIfExists(csvPath, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
        }
    }

    public void saveCSVFile(CSVDataSetDef def) {
        String path = def.getFilePath();
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        Path csvTempPath = this.resolveCsvTempPath(def);
        if (this.ioService.exists(csvTempPath)) {
            Path csvPath = this.resolveCsvPath(def);
            if (this.ioService.exists(csvPath)) {
                this.ioService.delete(csvPath, new DeleteOption[0]);
            }
            this.ioService.move(csvTempPath, csvPath, new CopyOption[0]);
            return;
        }
        File csvFile = new File(path);
        if (csvFile.exists()) {
            if (csvFile.length() > (long)this.maxCsvLength) {
                String msg = "CSV file length exceeds the maximum allowed: " + this.maxCsvLength / 1024 + " Kb";
                throw this.exceptionManager.handleException(new Exception(msg));
            }
            try {
                Path defPath = this.resolveCsvPath(def);
                String csvContent = FileUtils.readFileToString((File)csvFile);
                this.ioService.write(defPath, csvContent, new OpenOption[0]);
            }
            catch (Exception e) {
                String msg = "Error saving CSV file: " + csvFile;
                throw this.exceptionManager.handleException(new Exception(msg, e));
            }
        }
    }

    protected Path resolveCsvPath(CSVDataSetDef def) {
        return this.getDataSetsPath().resolve(def.getUUID() + CSV_EXT);
    }

    protected Path resolveCsvTempPath(CSVDataSetDef def) {
        return this.resolveTempPath(def.getUUID() + CSV_EXT);
    }

    void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        DataSetDef def = event.getDataSetDef();
        this.dataSetDefMap.put(def.getUUID(), new DataSetDefRegistryImpl.DataSetDefEntry((DataSetDefRegistryImpl)this, def));
    }
}

