/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.GraphBuilderTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.ProcessPostConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.UserTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.mockito.Mockito;

public class ProcessPostConverterTest {
    @Test
    public void testPostConvert() {
        DefinitionResolver definitionResolver = (DefinitionResolver)Mockito.mock(DefinitionResolver.class);
        double laneX = 80.0;
        double laneY = 100.0;
        double laneWidth = 500.0;
        double laneHeight = 200.0;
        RectangleDimensionsSet laneRectangleDimensionsSet = new RectangleDimensionsSet(Double.valueOf(laneWidth), Double.valueOf(laneHeight));
        Lane laneDefinition = (Lane)Mockito.mock(Lane.class);
        Mockito.when((Object)laneDefinition.getDimensionsSet()).thenReturn((Object)laneRectangleDimensionsSet);
        Node<? extends View<? extends BPMNViewDefinition>, ?> lane = GraphBuilderTest.mockNode((BPMNViewDefinition)laneDefinition, laneX, laneY, laneWidth, laneHeight);
        BpmnNode laneNode = GraphBuilderTest.mockBpmnNode(lane);
        double startEventX = 180.0;
        double startEventY = 130.0;
        double eventWidth = 56.0;
        double eventHeight = 56.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> startEvent = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(StartNoneEvent.class), startEventX + laneX, startEventY + laneY, eventWidth, eventHeight);
        BpmnNode startEventNode = GraphBuilderTest.mockBpmnNode(startEvent);
        double subprocessX = 270.0;
        double subprocessY = 180.0;
        double subprocessWidth = 100.0;
        double subprocessHeight = 60.0;
        RectangleDimensionsSet subprocessRectangleDimensionsSet = new RectangleDimensionsSet(Double.valueOf(subprocessWidth), Double.valueOf(subprocessHeight));
        EmbeddedSubprocess subprocessDefinition = (EmbeddedSubprocess)Mockito.mock(EmbeddedSubprocess.class);
        Mockito.when((Object)subprocessDefinition.getDimensionsSet()).thenReturn((Object)subprocessRectangleDimensionsSet);
        Node<? extends View<? extends BPMNViewDefinition>, ?> subprocess = GraphBuilderTest.mockNode((BPMNViewDefinition)subprocessDefinition, subprocessX + laneX, subprocessY + laneY, subprocessWidth, subprocessHeight);
        BpmnNode subprocessNode = GraphBuilderTest.mockBpmnNode(subprocess);
        BasePropertyReader subprocessPropertyReader = subprocessNode.getPropertyReader();
        Mockito.when((Object)subprocessPropertyReader.isExpanded()).thenReturn((Object)false);
        double subprocessBoundaryEventX = subprocessWidth - 28.0;
        double subprocessBoundaryEventY = subprocessHeight / 2.0 - 28.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> subprocessBoundaryEvent = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(IntermediateTimerEvent.class), subprocessBoundaryEventX, subprocessBoundaryEventY, eventWidth, eventHeight);
        BpmnNode subprocessBoundaryEventNode = GraphBuilderTest.mockBpmnNode(subprocessBoundaryEvent).docked();
        double task1X = 10.0;
        double task1Y = 10.0;
        double taskWidth = 200.0;
        double taskHeight = 100.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task1 = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(UserTask.class), task1X, task1Y, taskWidth, taskHeight);
        BpmnNode task1Node = GraphBuilderTest.mockBpmnNode(task1);
        double task2X = 300.0;
        double task2Y = 200.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task2 = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(UserTask.class), task2X, task2Y, taskWidth, taskHeight);
        BpmnNode task2Node = GraphBuilderTest.mockBpmnNode(task2);
        double task2BoundaryEventX = taskWidth - 28.0;
        double task2BoundaryEventY = taskHeight - 28.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task2BoundaryEvent = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(IntermediateTimerEvent.class), task2BoundaryEventX, task2BoundaryEventY, eventWidth, eventHeight);
        BpmnNode task2BoundaryEventNode = GraphBuilderTest.mockBpmnNode(task2BoundaryEvent).docked();
        double endEventX = 450.0;
        double endEventY = 230.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> endEvent = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(EndNoneEvent.class), endEventX + laneX, endEventY + laneY, eventWidth, eventHeight);
        BpmnNode endEventNode = GraphBuilderTest.mockBpmnNode(endEvent);
        double task3X = 500.0;
        double task3Y = 600.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task3 = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(UserTask.class), task3X + laneX, task3Y + laneY, taskWidth, taskHeight);
        BpmnNode task3Node = GraphBuilderTest.mockBpmnNode(task3);
        double task3BoundaryEventX = taskWidth - 28.0;
        double task3BoundaryEventY = taskHeight - 28.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task3BoundaryEvent = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(IntermediateTimerEvent.class), task3BoundaryEventX, task3BoundaryEventY, eventWidth, eventHeight);
        BpmnNode task3BoundaryEventNode = GraphBuilderTest.mockBpmnNode(task3BoundaryEvent).docked();
        double task4X = 900.0;
        double task4Y = 1000.0;
        Node<? extends View<? extends BPMNViewDefinition>, ?> task4 = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(UserTask.class), task4X + laneX, task4Y + laneY, taskWidth, taskHeight);
        BpmnNode task4Node = GraphBuilderTest.mockBpmnNode(task4);
        ArrayList<Point2D> controlPoints = new ArrayList<Point2D>();
        controlPoints.add(Point2D.create((double)(1000.0 + laneX), (double)(700.0 + laneY)));
        MagnetConnection sourceConnection = MagnetConnection.Builder.at((double)56.0, (double)28.0).setAuto(false);
        MagnetConnection targetConnection = MagnetConnection.Builder.at((double)100.0, (double)0.0).setAuto(false);
        BPMNEdge bpmnEdge = (BPMNEdge)Mockito.mock(BPMNEdge.class);
        BaseElement baseElement = (BaseElement)Mockito.mock(BaseElement.class);
        SequenceFlowPropertyReader edgePropertyReader = (SequenceFlowPropertyReader)Mockito.mock(SequenceFlowPropertyReader.class);
        Mockito.when((Object)edgePropertyReader.getDefinitionResolver()).thenReturn((Object)definitionResolver);
        Mockito.when((Object)edgePropertyReader.getElement()).thenReturn((Object)baseElement);
        Mockito.when((Object)baseElement.getId()).thenReturn((Object)"elementId");
        Mockito.when((Object)definitionResolver.getEdge("elementId")).thenReturn((Object)bpmnEdge);
        ArrayList<Point> wayPoints = new ArrayList<Point>();
        wayPoints.add(ProcessPostConverterTest.mockPoint((float)(728.0 + laneX), (float)(700.0 + laneY)));
        wayPoints.add(ProcessPostConverterTest.mockPoint((float)(1000.0 + laneX), (float)(700.0 + laneY)));
        wayPoints.add(ProcessPostConverterTest.mockPoint((float)(1000.0 + laneX), (float)(1000.0 + laneY)));
        Mockito.when((Object)bpmnEdge.getWaypoint()).thenReturn(wayPoints);
        Bounds sourceShapeBounds = ProcessPostConverterTest.mockBounds((float)(task3X + taskWidth - 28.0 + laneX), (float)(task3Y + taskHeight - 28.0 + laneY), (float)eventWidth, (float)eventHeight);
        BPMNShape sourceShape = ProcessPostConverterTest.mockShape(sourceShapeBounds);
        Mockito.when((Object)task3BoundaryEventNode.getPropertyReader().getShape()).thenReturn((Object)sourceShape);
        Bounds targetShapeBounds = ProcessPostConverterTest.mockBounds(((View)task4.getContent()).getBounds());
        BPMNShape targetShape = ProcessPostConverterTest.mockShape(targetShapeBounds);
        Mockito.when((Object)task4Node.getPropertyReader().getShape()).thenReturn((Object)targetShape);
        BpmnEdge.Simple edgeTask3BoundaryEventToTask4 = BpmnEdge.of(null, (BpmnNode)task3BoundaryEventNode, (Connection)sourceConnection, controlPoints, (BpmnNode)task4Node, (Connection)targetConnection, (PropertyReader)edgePropertyReader);
        Node<? extends View<? extends BPMNViewDefinition>, ?> diagram = GraphBuilderTest.mockNode((BPMNViewDefinition)Mockito.mock(BPMNDiagramImpl.class), 0.0, 0.0, 10000.0, 10000.0);
        BpmnNode rootNode = GraphBuilderTest.mockBpmnNode(diagram);
        rootNode.addChild(laneNode);
        laneNode.addChild(startEventNode);
        laneNode.addChild(subprocessNode);
        laneNode.addChild(subprocessBoundaryEventNode);
        rootNode.addEdge((BpmnEdge)BpmnEdge.docked((BpmnNode)subprocessNode, (BpmnNode)subprocessBoundaryEventNode));
        subprocessNode.addChild(task1Node);
        subprocessNode.addChild(task2Node);
        subprocessNode.addChild(task2BoundaryEventNode);
        subprocessNode.addEdge((BpmnEdge)BpmnEdge.docked((BpmnNode)task2Node, (BpmnNode)task2BoundaryEventNode));
        laneNode.addChild(task3Node);
        laneNode.addChild(task3BoundaryEventNode);
        laneNode.addChild(task4Node);
        rootNode.addEdge((BpmnEdge)BpmnEdge.docked((BpmnNode)task3Node, (BpmnNode)task3BoundaryEventNode));
        rootNode.addEdge((BpmnEdge)edgeTask3BoundaryEventToTask4);
        laneNode.addChild(endEventNode);
        ProcessPostConverter postConverter = new ProcessPostConverter();
        Mockito.when((Object)definitionResolver.getResolutionFactor()).thenReturn((Object)2.0);
        Result result = postConverter.postConvert(rootNode, definitionResolver);
        org.kie.workbench.common.stunner.core.graph.content.Bounds startEventBounds = ((View)startEventNode.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + startEventX), (double)startEventBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + startEventY), (double)startEventBounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)eventWidth, (double)startEventBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)eventHeight, (double)startEventBounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessBounds = ((View)subprocessNode.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + subprocessX), (double)subProcessBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + subprocessY), (double)subProcessBounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)510.0, (double)subProcessBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)310.0, (double)subProcessBounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds subProcessBoundaryEventBounds = ((View)subprocessBoundaryEventNode.value().getContent()).getBounds();
        Assert.assertEquals((double)(subProcessBounds.getWidth() - 28.0), (double)subProcessBoundaryEventBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(subProcessBounds.getHeight() / subprocessHeight * subprocessBoundaryEventY), (double)subProcessBoundaryEventBounds.getUpperLeft().getY(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task1Bounds = ((View)task1Node.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + subprocessX + task1X), (double)task1Bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + subprocessY + task1Y), (double)task1Bounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)taskWidth, (double)task1Bounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)taskHeight, (double)task1Bounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task2Bounds = ((View)task2Node.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + subprocessX + task2X), (double)task2Bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + subprocessY + task2Y), (double)task2Bounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)taskWidth, (double)task1Bounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)taskHeight, (double)task1Bounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task2BoundaryEventBounds = ((View)task2BoundaryEventNode.value().getContent()).getBounds();
        Assert.assertEquals((double)task2BoundaryEventX, (double)task2BoundaryEventBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)task2BoundaryEventY, (double)task2BoundaryEventBounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)eventWidth, (double)task2BoundaryEventBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)eventHeight, (double)task2BoundaryEventBounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds endEventBounds = ((View)endEventNode.value().getContent()).getBounds();
        double subprocessDeltaX = subProcessBounds.getWidth() - subprocessWidth;
        double subprocessDeltaY = subProcessBounds.getHeight() - subprocessHeight;
        Assert.assertEquals((double)(laneX + endEventX + subprocessDeltaX), (double)endEventBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + endEventY + subprocessDeltaY), (double)endEventBounds.getUpperLeft().getY(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task3Bounds = ((View)task3Node.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + task3X + subprocessDeltaX), (double)task3Bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + task3Y + subprocessDeltaY), (double)task3Bounds.getUpperLeft().getY(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task3BoundaryEventBounds = ((View)task3BoundaryEventNode.value().getContent()).getBounds();
        Assert.assertEquals((double)task3BoundaryEventX, (double)task3BoundaryEventBounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)task3BoundaryEventY, (double)task3BoundaryEventBounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)eventWidth, (double)task3BoundaryEventBounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)eventHeight, (double)task3BoundaryEventBounds.getHeight(), (double)0.0);
        org.kie.workbench.common.stunner.core.graph.content.Bounds task4Bounds = ((View)task4Node.value().getContent()).getBounds();
        Assert.assertEquals((double)(laneX + task4X + subprocessDeltaX), (double)task4Bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)(laneY + task4Y + subprocessDeltaY), (double)task4Bounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)56.0, (double)edgeTask3BoundaryEventToTask4.getSourceConnection().getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)28.0, (double)edgeTask3BoundaryEventToTask4.getSourceConnection().getLocation().getY(), (double)0.0);
        Assert.assertEquals((double)(((View)task4Node.value().getContent()).getBounds().getUpperLeft().getX() + taskWidth / 2.0), (double)((Point2D)controlPoints.get(0)).getX(), (double)0.0);
        Assert.assertEquals((double)((View)task3Node.value().getContent()).getBounds().getLowerRight().getY(), (double)((Point2D)controlPoints.get(0)).getY(), (double)0.0);
        List messages = result.messages();
        Assert.assertEquals((long)1L, (long)messages.size());
        MarshallingMessage message = (MarshallingMessage)messages.get(0);
        Assert.assertEquals((Object)Violation.Type.WARNING, (Object)message.getViolationType());
        Assert.assertEquals((Object)"MarshallingMessage.collapsedElementExpanded", (Object)message.getMessageKey());
    }

    private static Point mockPoint(float x, float y) {
        Point point = (Point)Mockito.mock(Point.class);
        Mockito.when((Object)Float.valueOf(point.getX())).thenReturn((Object)Float.valueOf(x));
        Mockito.when((Object)Float.valueOf(point.getY())).thenReturn((Object)Float.valueOf(y));
        return point;
    }

    private static Bounds mockBounds(float x, float y, float width, float height) {
        Bounds bounds = Factories.dc.createBounds();
        bounds.setX(x);
        bounds.setY(y);
        bounds.setWidth(width);
        bounds.setHeight(height);
        return bounds;
    }

    private static Bounds mockBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds bounds) {
        return ProcessPostConverterTest.mockBounds((float)bounds.getX(), (float)bounds.getY(), (float)bounds.getWidth(), (float)bounds.getHeight());
    }

    private static BPMNShape mockShape(Bounds bounds) {
        BPMNShape shape = (BPMNShape)Mockito.mock(BPMNShape.class);
        Mockito.when((Object)shape.getBounds()).thenReturn((Object)bounds);
        return shape;
    }
}

