/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.InterruptingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartEscalationEventTest
extends StartEventTest<StartEscalationEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/escalationStartEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_364A2074-C369-4DB1-8934-69CF40B9E025";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_CF77BB90-5F75-4246-9E17-21383063007D";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_A983FF22-5128-4C06-9D47-AB7525DF8039";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_1DC85B0B-28D9-4EAC-A53C-F0C1303E2B19";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 10;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ESCALATION_REF = "escalation01";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartEscalationEvent filledTop = (StartEscalationEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledTop.getGeneral(), "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledTop.getExecutionSet(), "escalation01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTop.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartEscalationEvent emptyTop = (StartEscalationEvent)this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyTop.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyTop.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ESCALATION_REF = "escalation02";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartEscalationEvent filledSubprocess = (StartEscalationEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledSubprocess.getGeneral(), "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocess.getExecutionSet(), "escalation02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocess.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartEscalationEvent emptySubprocess = (StartEscalationEvent)this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocess.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocess.getDataIOSet(), "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartEscalationEvent> getStartEventType() {
        return StartEscalationEvent.class;
    }

    private void assertEscalationEventExecutionSet(InterruptingEscalationEventExecutionSet executionSet, String escalationRef, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getEscalationRef());
        Assert.assertEquals((Object)escalationRef, (Object)executionSet.getEscalationRef().getValue());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

