/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.validation.CopyValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@ApplicationScoped
public class PlanningSolutionCopyValidator
implements CopyValidator<DataObject> {
    private DataModelerService dataModelerService;
    private IOService ioService;

    @Inject
    public PlanningSolutionCopyValidator(DataModelerService dataModelerService, @Named(value="ioStrategy") IOService ioService) {
        this.dataModelerService = dataModelerService;
        this.ioService = ioService;
    }

    public Collection<ValidationMessage> validate(Path dataObjectPath, DataObject dataObject) {
        if (dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
            return Arrays.asList(new PlanningSolutionToBeDuplicatedMessage(Level.ERROR));
        }
        return Collections.emptyList();
    }

    public Collection<ValidationMessage> validate(Path path) {
        if (path != null) {
            String dataObjectSource = this.ioService.readAllString(Paths.convert((Path)path));
            GenerationResult generationResult = this.dataModelerService.loadDataObject(path, dataObjectSource, path);
            if (generationResult.hasErrors()) {
                return Collections.emptyList();
            }
            DataObject dataObject = generationResult.getDataObject();
            if (dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
                return Arrays.asList(new PlanningSolutionToBeDuplicatedMessage(Level.ERROR));
            }
        }
        return Collections.emptyList();
    }

    public boolean accept(Path path) {
        return path.getFileName().endsWith(".java");
    }
}

