/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.gateways;

import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.Gateway;
import org.kie.workbench.common.stunner.bpmn.backend.converters.BPMNElementDecorators;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.AbstractConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GatewayPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.DefaultRoute;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.GatewayExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;

public class GatewayConverter
extends AbstractConverter
implements NodeConverter<Gateway> {
    private final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public GatewayConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory, MarshallingRequest.Mode mode) {
        super(mode);
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(Gateway gateway) {
        return Match.of(Gateway.class, Result.class).when(org.eclipse.bpmn2.ParallelGateway.class, this::parallelGateway).when(org.eclipse.bpmn2.ExclusiveGateway.class, this::exclusiveGateway).when(org.eclipse.bpmn2.InclusiveGateway.class, this::inclusiveGateway).when(EventBasedGateway.class, this::eventGateway).defaultValue(Result.ignored("Gateway not found", new MarshallingMessage[0])).inputDecorator(BPMNElementDecorators.flowElementDecorator()).outputDecorator(BPMNElementDecorators.resultBpmnDecorator()).mode(this.getMode()).apply(gateway).value();
    }

    private Result<BpmnNode> inclusiveGateway(Gateway gateway) {
        Node node = this.factoryManager.newNode(gateway.getId(), InclusiveGateway.class);
        InclusiveGateway definition = (InclusiveGateway)((View)node.getContent()).getDefinition();
        GatewayPropertyReader p = this.propertyReaderFactory.of(gateway);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        definition.setExecutionSet(new GatewayExecutionSet(new DefaultRoute(p.getDefaultRoute())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> exclusiveGateway(Gateway gateway) {
        Node node = this.factoryManager.newNode(gateway.getId(), ExclusiveGateway.class);
        ExclusiveGateway definition = (ExclusiveGateway)((View)node.getContent()).getDefinition();
        GatewayPropertyReader p = this.propertyReaderFactory.of(gateway);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new GatewayExecutionSet(new DefaultRoute(p.getDefaultRoute())));
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> parallelGateway(Gateway gateway) {
        Node node = this.factoryManager.newNode(gateway.getId(), ParallelGateway.class);
        GatewayPropertyReader p = this.propertyReaderFactory.of(gateway);
        ((View)node.getContent()).setBounds(p.getBounds());
        ParallelGateway definition = (ParallelGateway)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }

    private Result<BpmnNode> eventGateway(EventBasedGateway eventGateway) {
        Node node = this.factoryManager.newNode(eventGateway.getId(), EventGateway.class);
        GatewayPropertyReader p = this.propertyReaderFactory.of((Gateway)eventGateway);
        ((View)node.getContent()).setBounds(p.getBounds());
        EventGateway definition = (EventGateway)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }
}

