/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.util;

import java.util.function.IntSupplier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class RhinoJavaScriptPoolSizer
implements IntSupplier {
    private final String propertyName;
    private final String script;

    public RhinoJavaScriptPoolSizer(String propertyName, String script) {
        this.propertyName = propertyName;
        this.script = script;
    }

    @Override
    public int getAsInt() {
        String actualScript = "var availableProcessorCount = " + Runtime.getRuntime().availableProcessors() + ";\n" + this.script;
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            Object result = cx.evaluateString((Scriptable)scope, actualScript, "source", 1, null);
            int n = ((Double)result).intValue();
            return n;
        }
        catch (RhinoException e) {
            throw new IllegalArgumentException("The " + this.propertyName + " (" + this.script + ") cannot be parsed in JavaScript with the variables ([" + "availableProcessorCount" + "]).", e);
        }
        finally {
            Context.exit();
        }
    }
}

