/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import java.util.Arrays;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JiraResolveIssue.wid", name="JiraResolveIssue", displayName="JiraResolveIssue", defaultHandler="mvel: new org.jbpm.process.workitem.jira.ResolveIssueWorkitemHandler(\"userName\", \"password\", \"repoURI\")", documentation="jira-workitem/index.html", category="jira-workitem", icon="JiraResolveIssue.png", parameters={@WidParameter(name="IssueKey", required=true), @WidParameter(name="Resolution", required=true), @WidParameter(name="ResolutionComment")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jira-workitem", version="7.69.0.Final")}, serviceInfo=@WidService(category="Jira", description="Create or update Jiras", keywords="jira,issue,resolve", action=@WidAction(title="Resolve existing Jira issue"), authinfo=@WidAuth(required=true, params={"userName", "password", "repoURI"}, paramsdescription={"Jira user", "Jira password", "Repository URI"}, referencesite="https://www.atlassian.com/software/jira")))
public class ResolveIssueWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private String repoURI;
    private JiraAuth auth;
    private static final Logger logger = LoggerFactory.getLogger(ResolveIssueWorkitemHandler.class);

    public ResolveIssueWorkitemHandler(String userName, String password, String repoURI) {
        this.userName = userName;
        this.password = password;
        this.repoURI = repoURI;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String issueKey = (String)workItem.getParameter("IssueKey");
            String resolution = (String)workItem.getParameter("Resolution");
            String resolutionComment = (String)workItem.getParameter("ResolutionComment");
            if (this.auth == null) {
                this.auth = new JiraAuth(this.userName, this.password, this.repoURI);
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            Issue issue = this.auth.getIssueRestClient().getIssue(issueKey, (ProgressMonitor)progressMonitor);
            if (issue == null) {
                logger.error("Could not find issue with key: " + issueKey);
                throw new IllegalArgumentException("Could not find issue with key: " + issueKey);
            }
            Iterable transitions = this.auth.getIssueRestClient().getTransitions(issue.getTransitionsUri(), (ProgressMonitor)progressMonitor);
            Transition resolveIssueTransition = ResolveIssueWorkitemHandler.getTransitionByName(transitions, "Resolve Issue");
            List<FieldInput> fieldInputs = Arrays.asList(new FieldInput("resolution", (Object)resolution));
            TransitionInput transitionInput = new TransitionInput(resolveIssueTransition.getId(), fieldInputs, Comment.valueOf((String)resolutionComment));
            this.auth.getIssueRestClient().transition(issue.getTransitionsUri(), transitionInput, (ProgressMonitor)progressMonitor);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    private static Transition getTransitionByName(Iterable<Transition> transitions, String transitionName) {
        for (Transition transition : transitions) {
            if (!transition.getName().equals(transitionName)) continue;
            return transition;
        }
        return null;
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(JiraAuth auth) {
        this.auth = auth;
    }
}

