/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.clone;

import java.util.Objects;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.clone.CloneProcess;

public abstract class AbstractCloneProcess
implements CloneProcess {
    private final FactoryManager factoryManager;
    final AdapterManager adapterManager;

    public AbstractCloneProcess(FactoryManager factoryManager, AdapterManager adapterManager) {
        this.factoryManager = factoryManager;
        this.adapterManager = adapterManager;
    }

    @Override
    public <T> T clone(T source) {
        return this.clone(source, this.createEmptyClone(source));
    }

    private <T> T createEmptyClone(T source) {
        Objects.requireNonNull(source, "Source cannot be null");
        return (T)this.factoryManager.newDefinition(this.adapterManager.forDefinition().getId(source).value());
    }
}

