/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.content.view;

import java.util.Objects;
import java.util.function.Function;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class MagnetConnection
extends DiscreteConnection {
    public static final int MAGNET_CENTER = 0;
    public static final int MAGNET_TOP = 1;
    public static final int MAGNET_RIGHT = 2;
    public static final int MAGNET_BOTTOM = 3;
    public static final int MAGNET_LEFT = 4;
    private Point2D location;
    private Boolean auto;

    private MagnetConnection(@MapsTo(value="location") Point2D location, @MapsTo(value="auto") Boolean auto) {
        PortablePreconditions.checkNotNull((String)"auto", (Object)auto);
        this.location = location;
        this.auto = auto;
    }

    private MagnetConnection(int index) {
        this.setIndex(index);
    }

    public MagnetConnection setLocation(Point2D location) {
        this.location = location;
        return this;
    }

    public MagnetConnection setAuto(boolean auto) {
        this.auto = auto;
        return this;
    }

    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public boolean isAuto() {
        return this.auto;
    }

    public boolean equals(Object o) {
        if (o instanceof MagnetConnection) {
            MagnetConnection other = (MagnetConnection)o;
            return (null != this.location && null != other.location ? this.location.getX() == other.location.getX() && this.location.getY() == other.location.getY() : null == this.location && null == other.location) && (null != this.auto ? this.auto.equals(other.auto) : null == other.auto);
        }
        return false;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{null != this.location ? HashUtil.combineHashCodes((int[])new int[]{1, Double.hashCode(this.location.getX()), Double.hashCode(this.location.getY())}) : 0, null != this.auto ? this.auto.hashCode() : 0});
    }

    public String toString() {
        return "[MagnetConnection at {" + this.location + "}]";
    }

    @NonPortable
    public static class Builder {
        private Double x;
        private Double y;
        private boolean auto = false;
        private Integer magnet;

        public Builder atX(double x) {
            this.x = x;
            return this;
        }

        public Builder atY(double y) {
            this.y = y;
            return this;
        }

        public Builder auto() {
            return this.auto(true);
        }

        public Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public Builder magnet(int index) {
            this.magnet = index;
            return this;
        }

        public MagnetConnection build() {
            Point2D p = null != this.x && null != this.y ? new Point2D(this.x.doubleValue(), this.y.doubleValue()) : null;
            MagnetConnection connection = new MagnetConnection(p, this.auto);
            if (null != this.magnet) {
                connection.setIndex(this.magnet);
            }
            return connection;
        }

        public static MagnetConnection at(double x, double y) {
            return new MagnetConnection(new Point2D(x, y), false);
        }

        public static MagnetConnection forTarget(Element<? extends View<?>> source, Element<? extends View<?>> target) {
            RelativePosition relativePosition = Builder.getTargetPositionRelativeToSource(source, target);
            switch (relativePosition) {
                case ABOVE: {
                    return Builder.atTop(source);
                }
                case BELOW: {
                    return Builder.atBottom(source);
                }
                case LEFT: {
                    return Builder.atLeft(source);
                }
                case RIGHT: {
                    return Builder.atRight(source);
                }
            }
            return Builder.atCenter(source);
        }

        private static RelativePosition getTargetPositionRelativeToSource(Element<? extends View<?>> source, Element<? extends View<?>> target) {
            Point2D sourcePosition = GraphUtils.getPosition((View)source.getContent());
            Point2D targetPosition = Objects.nonNull(target) ? GraphUtils.getPosition((View)target.getContent()) : sourcePosition;
            Bounds sourceBounds = ((View)source.getContent()).getBounds();
            Bounds targetBounds = ((View)target.getContent()).getBounds();
            if (targetPosition.getY() + targetBounds.getHeight() < sourcePosition.getY()) {
                return RelativePosition.ABOVE;
            }
            if (targetPosition.getY() > sourcePosition.getY() + sourceBounds.getHeight()) {
                return RelativePosition.BELOW;
            }
            if (targetPosition.getX() + targetBounds.getWidth() < sourcePosition.getX()) {
                return RelativePosition.LEFT;
            }
            if (targetPosition.getX() > sourcePosition.getX() + sourceBounds.getWidth()) {
                return RelativePosition.RIGHT;
            }
            return RelativePosition.CENTRE;
        }

        public static MagnetConnection atCenter(Element<? extends View<?>> element) {
            return Builder.atLocation(element, 0, bounds -> bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0 ? new Point2D(bounds.getWidth() / 2.0, bounds.getHeight() / 2.0) : null, false);
        }

        public static MagnetConnection atTop(Element<? extends View<?>> element) {
            return Builder.atLocation(element, 1, bounds -> bounds.getWidth() > 0.0 ? new Point2D(bounds.getWidth() / 2.0, 0.0) : null);
        }

        public static MagnetConnection atBottom(Element<? extends View<?>> element) {
            return Builder.atLocation(element, 3, bounds -> bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0 ? new Point2D(bounds.getWidth() / 2.0, bounds.getHeight()) : null);
        }

        public static MagnetConnection atRight(Element<? extends View<?>> element) {
            return Builder.atLocation(element, 2, bounds -> bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0 ? new Point2D(bounds.getWidth(), bounds.getHeight() / 2.0) : null);
        }

        public static MagnetConnection atLeft(Element<? extends View<?>> element) {
            return Builder.atLocation(element, 4, bounds -> bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0 ? new Point2D(0.0, bounds.getHeight() / 2.0) : null);
        }

        private static MagnetConnection atLocation(Element<? extends View<?>> element, int magnet, Function<Bounds, Point2D> atResolver) {
            return Builder.atLocation(element, magnet, atResolver, true);
        }

        private static MagnetConnection atLocation(Element<? extends View<?>> element, int magnet, Function<Bounds, Point2D> atResolver, boolean isAuto) {
            Bounds bounds = ((View)element.getContent()).getBounds();
            Point2D at = atResolver.apply(bounds);
            return new MagnetConnection(magnet).setLocation(at).setAuto(isAuto);
        }

        private static enum RelativePosition {
            ABOVE,
            BELOW,
            LEFT,
            RIGHT,
            CENTRE;

        }
    }
}

