/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.inject.Default;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step03.VertexLayerPositioning;

@Default
public class MedianVertexLayerPositioning
implements VertexLayerPositioning {
    public void positionVertices(List<GraphLayer> layers, List<OrientedEdge> edges, int currentIteration) {
        if (currentIteration % 2 == 0) {
            for (int j = layers.size() - 1; j >= 1; --j) {
                GraphLayer currentLayer = layers.get(j);
                for (Vertex vertex : currentLayer.getVertices()) {
                    double median = this.calculateMedianOfVerticesConnectedTo(vertex.getId(), layers.get(j - 1), edges);
                    vertex.setMedian(median);
                }
                currentLayer.getVertices().sort(Vertex::compareTo);
            }
        } else {
            for (int j = 0; j < layers.size() - 1; ++j) {
                GraphLayer currentLayer = layers.get(j);
                for (Vertex vertex : layers.get(j).getVertices()) {
                    double median = this.calculateMedianOfVerticesConnectedTo(vertex.getId(), layers.get(j + 1), edges);
                    vertex.setMedian(median);
                }
                currentLayer.getVertices().sort(Vertex::compareTo);
            }
        }
    }

    public double calculateMedianOfVerticesConnectedTo(String vertex, GraphLayer layer, List<OrientedEdge> edges) {
        ArrayList<Integer> connectedVerticesIndex = new ArrayList<Integer>();
        List vertices = layer.getVertices();
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex vertexInLayer = (Vertex)vertices.get(i);
            boolean hasConnection = edges.stream().anyMatch(e -> e.isLinkedWithVertexId(vertexInLayer.getId()) && e.isLinkedWithVertexId(vertex));
            if (!hasConnection) continue;
            connectedVerticesIndex.add(i);
        }
        int size = connectedVerticesIndex.size();
        if (size == 0) {
            Optional<Vertex> first = layer.getVertices().stream().filter(v -> Objects.equals(v.getId(), vertex)).findFirst();
            return first.map(vertex1 -> layer.getVertices().indexOf(vertex1)).orElse(-1).intValue();
        }
        if (size == 1) {
            return ((Integer)connectedVerticesIndex.get(0)).intValue();
        }
        double median = size % 2 == 0 ? ((double)((Integer)connectedVerticesIndex.get(size / 2)).intValue() + (double)((Integer)connectedVerticesIndex.get(size / 2 - 1)).intValue()) / 2.0 : (double)((Integer)connectedVerticesIndex.get(size / 2)).intValue();
        return median;
    }
}

