/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.traverse.content;

import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractContentTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@Dependent
public final class ChildrenTraverseProcessorImpl
extends AbstractContentTraverseProcessor<Child, Node<View, Edge>, Edge<Child, Node>, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>>
implements ChildrenTraverseProcessor {
    private final ParentStack parentStack = new ParentStack();

    @Inject
    public ChildrenTraverseProcessorImpl(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        super(treeWalkTraverseProcessor);
        treeWalkTraverseProcessor.useStartNodePredicate(node -> !node.getInEdges().stream().filter(e -> e.getContent() instanceof Child).findAny().isPresent());
    }

    public ChildrenTraverseProcessor setRootUUID(String rootUUID) {
        this.parentStack.setRootUUID(rootUUID);
        return this;
    }

    @Override
    protected void doStartGraphTraversal(Graph graph, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        this.parentStack.clear();
    }

    @Override
    protected boolean doStartEdgeTraversal(Edge edge, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        if (this.accepts(edge)) {
            Node parent = edge.getSourceNode();
            this.parentStack.push((Node<View, Edge>)parent);
            callback.startEdgeTraversal(edge);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEndEdgeTraversal(Edge edge, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        if (this.accepts(edge)) {
            this.parentStack.pop();
            callback.endEdgeTraversal(edge);
            return true;
        }
        return false;
    }

    @Override
    protected void doEndGraphTraversal(Graph graph, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        callback.endGraphTraversal();
        this.parentStack.clear();
    }

    @Override
    protected boolean doStartNodeTraversal(Node node, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        if (!this.parentStack.isRootDefined() || this.parentStack.isRootPresent()) {
            return this.fireNodeTraverseCallback(node, callback);
        }
        return true;
    }

    private boolean fireNodeTraverseCallback(Node node, ChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>> callback) {
        if (!this.parentStack.isEmpty()) {
            return callback.startNodeTraversal(this.parentStack.asList(), node);
        }
        callback.startNodeTraversal(node);
        return true;
    }

    @Override
    protected boolean accepts(Edge edge) {
        return edge.getContent() instanceof Child;
    }

    private class ParentStack {
        private final Stack<Node<View, Edge>> stack = new Stack();
        private Optional<String> rootUUID = Optional.empty();
        private boolean hasParent = false;

        public void setRootUUID(String uuid) {
            this.rootUUID = Optional.ofNullable(uuid);
        }

        public Node<View, Edge> push(Node<View, Edge> item) {
            if (this.isRootUUID(item)) {
                this.hasParent = true;
            }
            return this.stack.push(item);
        }

        public Node<View, Edge> peek() {
            return this.stack.peek();
        }

        public Node<View, Edge> pop() {
            Node<View, Edge> pop = this.stack.pop();
            if (this.isRootUUID(pop)) {
                this.hasParent = false;
            }
            return pop;
        }

        public void clear() {
            this.hasParent = false;
            this.stack.clear();
        }

        public boolean isRootDefined() {
            return this.rootUUID.isPresent();
        }

        public boolean isRootPresent() {
            return this.hasParent;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public List<Node<View, Edge>> asList() {
            return this.stack.stream().collect(Collectors.toList());
        }

        private boolean isRootUUID(Node node) {
            return this.rootUUID.isPresent() && null != node && node.getUUID().equals(this.rootUUID.get());
        }
    }
}

