/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.command.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class CommandUtils {
    public static String[] toUUIDs(Collection<Node<?, Edge>> nodes) {
        return (String[])nodes.stream().map(Element::getUUID).toArray(String[]::new);
    }

    public static Collection<Node<?, Edge>> getCandidates(GraphCommandExecutionContext context, String[] candidateUUIDs) {
        Index<?, ?> graphIndex = context.getGraphIndex();
        return Stream.of(candidateUUIDs).map(graphIndex::getNode).collect(Collectors.toSet());
    }

    public static boolean isError(CommandResult<?> result) {
        return CommandUtils.isCommandResultError(result);
    }

    public static boolean isWarn(CommandResult<?> result) {
        return CommandUtils.isCommandResultWarn(result);
    }

    public static CommandResult.Type getType(RuleViolation violation) {
        switch (violation.getViolationType()) {
            case ERROR: {
                return CommandResult.Type.ERROR;
            }
            case WARNING: {
                return CommandResult.Type.WARNING;
            }
        }
        return CommandResult.Type.INFO;
    }

    public static <V> List<V> toList(Iterable<V> iterable) {
        LinkedList result = new LinkedList();
        iterable.iterator().forEachRemaining(result::add);
        return result;
    }

    private static boolean isCommandResultError(CommandResult<?> result) {
        return result != null && CommandResult.Type.ERROR.equals((Object)result.getType());
    }

    private static boolean isCommandResultWarn(CommandResult<?> result) {
        return result != null && CommandResult.Type.WARNING.equals((Object)result.getType());
    }
}

