/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ValueWrapper<T> {
    private final boolean valid;
    private final T value;
    private final T expected;
    private final String errorMessage;
    private final List<String> collectionPathToValue;

    private ValueWrapper(T value, T expected, boolean valid, String errorMessage, List<String> collectionPathToValue) {
        this.valid = valid;
        this.value = value;
        this.expected = expected;
        this.errorMessage = errorMessage;
        this.collectionPathToValue = collectionPathToValue;
    }

    public static <T> ValueWrapper<T> of(T value) {
        return new ValueWrapper<Object>(value, null, true, null, null);
    }

    public static <T> ValueWrapper<T> errorWithValidValue(T value, T expected) {
        return new ValueWrapper<T>(value, expected, false, null, null);
    }

    public static <T> ValueWrapper<T> errorWithMessage(String message) {
        return new ValueWrapper<Object>(null, null, false, message, null);
    }

    public static <T> ValueWrapper<T> errorEmptyMessage() {
        return new ValueWrapper<Object>(null, null, false, null, null);
    }

    public static <T> ValueWrapper<T> errorWithCollectionPathToValue(T value, List<String> path) {
        return new ValueWrapper<Object>(value, null, false, null, path);
    }

    public boolean isValid() {
        return this.valid;
    }

    public T getValue() {
        return this.value;
    }

    public T getExpected() {
        return this.expected;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public List<String> getCollectionPathToValue() {
        return this.collectionPathToValue;
    }

    public T orElse(T defaultValue) {
        return this.valid ? this.value : defaultValue;
    }

    public T orElseGet(Supplier<T> defaultSupplier) {
        return this.valid ? this.value : defaultSupplier.get();
    }
}

