/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.di.impl;

import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNLabel;
import org.eclipse.bpmn2.di.BPMNLabelStyle;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.di.DocumentRoot;
import org.eclipse.bpmn2.di.MessageVisibleKind;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.di.impl.BPMNDiagramImpl;
import org.eclipse.bpmn2.di.impl.BPMNEdgeImpl;
import org.eclipse.bpmn2.di.impl.BPMNLabelImpl;
import org.eclipse.bpmn2.di.impl.BPMNLabelStyleImpl;
import org.eclipse.bpmn2.di.impl.BPMNPlaneImpl;
import org.eclipse.bpmn2.di.impl.BPMNShapeImpl;
import org.eclipse.bpmn2.di.impl.DocumentRootImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class BpmnDiFactoryImpl
extends EFactoryImpl
implements BpmnDiFactory {
    public static BpmnDiFactory init() {
        try {
            BpmnDiFactory theBpmnDiFactory = (BpmnDiFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.omg.org/spec/BPMN/20100524/DI-XMI");
            if (theBpmnDiFactory != null) {
                return theBpmnDiFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BpmnDiFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDocumentRoot();
            }
            case 1: {
                return this.createBPMNDiagram();
            }
            case 2: {
                return this.createBPMNEdge();
            }
            case 3: {
                return this.createBPMNLabel();
            }
            case 4: {
                return this.createBPMNLabelStyle();
            }
            case 5: {
                return this.createBPMNPlane();
            }
            case 6: {
                return this.createBPMNShape();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createMessageVisibleKindFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createParticipantBandKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertMessageVisibleKindToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertParticipantBandKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    @Override
    public BPMNDiagram createBPMNDiagram() {
        BPMNDiagramImpl bpmnDiagram = new BPMNDiagramImpl();
        return bpmnDiagram;
    }

    @Override
    public BPMNEdge createBPMNEdge() {
        BPMNEdgeImpl bpmnEdge = new BPMNEdgeImpl();
        return bpmnEdge;
    }

    @Override
    public BPMNLabel createBPMNLabel() {
        BPMNLabelImpl bpmnLabel = new BPMNLabelImpl();
        return bpmnLabel;
    }

    @Override
    public BPMNLabelStyle createBPMNLabelStyle() {
        BPMNLabelStyleImpl bpmnLabelStyle = new BPMNLabelStyleImpl();
        return bpmnLabelStyle;
    }

    @Override
    public BPMNPlane createBPMNPlane() {
        BPMNPlaneImpl bpmnPlane = new BPMNPlaneImpl();
        return bpmnPlane;
    }

    @Override
    public BPMNShape createBPMNShape() {
        BPMNShapeImpl bpmnShape = new BPMNShapeImpl();
        return bpmnShape;
    }

    public MessageVisibleKind createMessageVisibleKindFromString(EDataType eDataType, String initialValue) {
        MessageVisibleKind result = MessageVisibleKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMessageVisibleKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ParticipantBandKind createParticipantBandKindFromString(EDataType eDataType, String initialValue) {
        ParticipantBandKind result = ParticipantBandKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertParticipantBandKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public BpmnDiPackage getBpmnDiPackage() {
        return (BpmnDiPackage)this.getEPackage();
    }

    @Deprecated
    public static BpmnDiPackage getPackage() {
        return BpmnDiPackage.eINSTANCE;
    }
}

