/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class AddConnectorCommand
extends AbstractGraphCompositeCommand {
    private final String nodeUUID;
    private final Edge edge;
    private final Connection connection;
    private transient Node<?, Edge> node;

    public AddConnectorCommand(@MapsTo(value="nodeUUID") String nodeUUID, @MapsTo(value="edge") Edge edge, @MapsTo(value="magnet") Connection connection) {
        this.nodeUUID = (String)PortablePreconditions.checkNotNull((String)"nodeUUID", (Object)nodeUUID);
        this.edge = (Edge)PortablePreconditions.checkNotNull((String)"edge", (Object)edge);
        this.connection = (Connection)PortablePreconditions.checkNotNull((String)"magnet", (Object)connection);
    }

    public AddConnectorCommand(Node<?, Edge> sourceNode, Edge edge, Connection connection) {
        this(sourceNode.getUUID(), edge, connection);
        this.node = sourceNode;
    }

    protected AddConnectorCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        Node<?, Edge> source = this.getNode(context);
        this.commands.add(new SetConnectionSourceNodeCommand(source, (Edge<? extends View, Node>)this.edge, this.connection));
        return this;
    }

    @Override
    public CommandResult<RuleViolation> allow(GraphCommandExecutionContext context) {
        this.getMutableIndex(context).addEdge(this.edge);
        CommandResult results = super.allow(context);
        if (CommandUtils.isError(results)) {
            this.getMutableIndex(context).removeEdge(this.edge);
        }
        return results;
    }

    @Override
    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        this.getMutableIndex(context).addEdge(this.edge);
        CommandResult results = super.execute(context);
        if (CommandUtils.isError(results)) {
            this.getMutableIndex(context).removeEdge(this.edge);
        }
        return results;
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        DeleteConnectorCommand undoCommand = new DeleteConnectorCommand((Edge<? extends View, Node>)this.edge);
        return undoCommand.execute(context);
    }

    private Node<?, Edge> getNode(GraphCommandExecutionContext context) {
        if (null == this.node) {
            this.node = this.getNode(context, this.nodeUUID);
        }
        return this.node;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Node<?, Edge> getSourceNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "AddEdgeCommand [target=" + this.nodeUUID + ", edge=" + this.edge.getUUID() + ", magnet=" + this.connection + "]";
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }
}

