/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.content.HasControlPoints;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class DeleteControlPointCommand
extends AbstractControlPointCommand {
    private final int index;
    private transient ControlPoint deletedControlPoint;

    public DeleteControlPointCommand(@MapsTo(value="edgeUUID") String edgeUUID, @MapsTo(value="index") int index) {
        super(edgeUUID);
        this.index = index;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        ControlPointValidations.checkDeleteControlPoint(this.getEdgeControlPoints(context).getControlPoints(), this.index);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        this.check(context);
        HasControlPoints edgeControlPoints = this.getEdgeControlPoints(context);
        int size = edgeControlPoints.getControlPoints().length;
        ControlPoint[] cps = new ControlPoint[size - 1];
        int i = 0;
        int j = 0;
        while (i < size) {
            ControlPoint controlPoint = edgeControlPoints.getControlPoints()[i];
            if (i == this.index) {
                --j;
                this.deletedControlPoint = controlPoint;
            } else {
                cps[j] = controlPoint;
            }
            ++i;
            ++j;
        }
        edgeControlPoints.setControlPoints(cps);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new AddControlPointCommand(this.getEdgeUUID(), this.deletedControlPoint, this.index).execute(context);
    }
}

